/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.utils;

import java.awt.Rectangle;
import java.awt.Window;
import java.util.Properties;

public class PropertiesEx
extends Properties {
    private static final long serialVersionUID = -739562636951242581L;
    private static final String MAIN = "Main";
    private static final String WINDOW = "Window";
    private static final char H = 'H';
    private static final char W = 'W';
    private static final char Y = 'Y';
    private static final char X = 'X';

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getProperty(key, defaultValue);
        return value == null || value.length() == 0 ? null : value;
    }

    public void putString(String key, String value) {
        this.put(key, value);
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public int getInt(String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(key, Integer.toString(defaultValue)));
    }

    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String key, long defaultValue) {
        return Long.parseLong(this.getProperty(key, Long.toString(defaultValue)));
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        return Double.parseDouble(this.getProperty(key, Double.toString(defaultValue)));
    }

    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getProperty(key, Boolean.toString(defaultValue)));
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumType, String key) {
        return this.getEnum(enumType, key, null);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumType, String key, T defaultValue) {
        String property = this.getProperty(key);
        return property == null ? defaultValue : Enum.valueOf(enumType, property);
    }

    public <T extends Enum<T>> void putEnum(String key, T value) {
        this.put(key, value.name());
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        String str;
        if (!(value == null || value instanceof String && (str = (String)value).length() == 0)) {
            return super.put(key, value);
        }
        this.remove(key);
        return null;
    }

    public void storeStagePlacement(Window stage) {
        this.putWindowPlacement(MAIN, -1, stage);
    }

    public void restoreStagePlacement(Window stage) {
        this.restoreWindowPlacement(MAIN, stage);
    }

    public void restoreWindowPlacement(String name, Window window) {
        this.restoreWindowPlacement(name, -1, window);
    }

    public void restoreWindowPlacement(String name, int id, Window window) {
        Rectangle bounds = this.getWindowPlacement(name, id);
        if (bounds != null) {
            window.setBounds(Math.max(0, (int)bounds.getX()), Math.max(0, (int)bounds.getY()), (int)bounds.getWidth(), (int)bounds.getHeight());
        }
    }

    public Rectangle getWindowPlacement(String name, int id) {
        String prop = PropertiesEx.buildPropertyName(name, id);
        int width = (int)this.getDouble(prop + "W");
        int height = (int)this.getDouble(prop + "H");
        return width <= 0 || height <= 0 ? null : new Rectangle((int)this.getDouble(prop + "X"), (int)this.getDouble(prop + "Y"), width, height);
    }

    public void putWindowPlacement(String name, Window window) {
        this.putWindowPlacement(name, -1, window);
    }

    public void putWindowPlacement(String name, int id, Window window) {
        String prop = PropertiesEx.buildPropertyName(name, id);
        double x = window.getX();
        double y = window.getY();
        double width = window.getWidth();
        double height = window.getHeight();
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(width) || Double.isNaN(height)) {
            return;
        }
        this.putDouble(prop + "X", x);
        this.putDouble(prop + "Y", y);
        this.putDouble(prop + "W", width);
        this.putDouble(prop + "H", height);
    }

    private static String buildPropertyName(String name, int id) {
        StringBuilder propStr = new StringBuilder(name);
        if (id != -1) {
            propStr.append(id);
        }
        return propStr.append(WINDOW).toString();
    }
}

