/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.utils;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;

public class FontCache {
    public static final String SANS_SERIF = "SansSerif";
    public static final String MONOSPACED = "Monospaced";
    private final Font baseFont;
    private final Map<Double, Font> scaledFonts = new HashMap<Double, Font>();

    public FontCache(String baseName) {
        this(baseName, 0, 16);
    }

    public FontCache(String baseName, int baseStyle, int baseSize) {
        this.baseFont = new Font(baseName, baseStyle, baseSize);
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(int size) {
        double scale = (double)size / (double)this.baseFont.getSize();
        Double s = scale;
        Map<Double, Font> map = this.scaledFonts;
        synchronized (map) {
            return this.scaledFonts.computeIfAbsent(s, key -> this.baseFont.deriveFont(AffineTransform.getScaleInstance(scale, scale)));
        }
    }
}

