/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.reaper.framework.midi.MidiMessageHandler;
import de.mossgrabers.reaper.ui.utils.LogModel;
import java.util.HashSet;
import java.util.Set;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;

public class MidiConnection {
    private static final Set<MidiDevice> USED_DEVICES = new HashSet<MidiDevice>(1);
    private MidiDevice midiInputDevice;
    private MidiDevice midiOutputDevice;
    private Receiver receiver;
    private Transmitter transmitter;
    private final LogModel model;
    private final Object sendLock = new Object();

    public MidiConnection(LogModel model) {
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutput(MidiDevice device) {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.receiver != null) {
                this.receiver.close();
                this.receiver = null;
            }
            if (device == null) {
                return;
            }
            try {
                this.midiOutputDevice = device;
                if (!this.midiOutputDevice.isOpen()) {
                    this.midiOutputDevice.open();
                }
                if (!this.midiOutputDevice.isOpen()) {
                    throw new MidiUnavailableException("Could not open MIDI output device: " + this.midiOutputDevice.getDeviceInfo().getName());
                }
                this.receiver = this.midiOutputDevice.getReceiver();
                USED_DEVICES.add(device);
            }
            catch (MidiUnavailableException ex) {
                String message = ex.getMessage();
                if (message != null && message.startsWith("There is not enough memory available for this task")) {
                    this.model.error("The MIDI output port '" + device.getDeviceInfo().getName() + "' is already opened by another application. This could also be caused by a previous run of an application which did not close the port correctly. Furthermore, make sure that you did deactivate this port in Reaper itself!", null);
                }
                this.model.error(ex.getLocalizedMessage(), null);
            }
        }
    }

    public void setInput(MidiDevice device, MidiMessageHandler callback) {
        if (this.transmitter != null) {
            this.transmitter.close();
            this.transmitter = null;
        }
        if (device == null) {
            return;
        }
        USED_DEVICES.add(device);
        try {
            this.midiInputDevice = device;
            if (!this.midiInputDevice.isOpen()) {
                this.midiInputDevice.open();
            }
            this.transmitter = this.midiInputDevice.getTransmitter();
            this.transmitter.setReceiver(new InternalMidiReceiver(this, callback));
        }
        catch (MidiUnavailableException ex) {
            String message = ex.getMessage();
            if (message != null && message.startsWith("There is not enough memory available for this task")) {
                this.model.error("The MIDI output port '" + device.getDeviceInfo().getName() + "' is already opened by another application. This could also be caused by a previous run of an application which did not close the port correctly. Furthermore, make sure that you did deactivate this port in Reaper itself!", null);
            }
            this.model.error(ex.getLocalizedMessage(), null);
        }
    }

    public void sendSysex(byte[] data) {
        try {
            this.send(new SysexMessage(data, data.length));
        }
        catch (InvalidMidiDataException ex) {
            this.model.error("Invalid Midi data.", ex);
        }
    }

    public void sendCC(int cc, int value) {
        this.send(this.createShortMessage(176, cc, value));
    }

    public void sendNote(int channel, int note, int velocity) {
        this.send(this.createShortMessage(144 + channel, note, velocity));
    }

    public void sendPitchbend(int value) {
        this.send(this.createShortMessage(224, 0, value));
    }

    public void sendRaw(int status, int data1, int data2) {
        this.send(this.createShortMessage(status, data1, data2));
    }

    public boolean isInputOpen() {
        return this.transmitter != null && this.midiInputDevice.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.sendLock;
        synchronized (object) {
            if (this.receiver != null) {
                this.receiver.close();
                this.receiver = null;
            }
        }
        if (this.transmitter != null) {
            Receiver r = this.transmitter.getReceiver();
            if (r != null) {
                r.close();
            }
            this.transmitter.setReceiver(null);
            this.transmitter.close();
            this.transmitter = null;
        }
        if (this.midiInputDevice != null) {
            this.midiInputDevice.close();
            USED_DEVICES.remove(this.midiInputDevice);
        }
        if (this.midiOutputDevice != null) {
            this.midiOutputDevice.close();
            USED_DEVICES.remove(this.midiOutputDevice);
        }
    }

    public static void cleanupUnusedDevices() {
        for (MidiDevice device : USED_DEVICES) {
            device.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(MidiMessage message) {
        if (message == null) {
            return;
        }
        Object object = this.sendLock;
        synchronized (object) {
            if (this.receiver == null) {
                return;
            }
            if (this.midiOutputDevice.isOpen()) {
                this.receiver.send(message, -1L);
            } else {
                this.model.error("Attempt to send to closed MIDI output: " + this.midiOutputDevice.getDeviceInfo().getName(), null);
            }
        }
    }

    private ShortMessage createShortMessage(int status, int data1, int data2) {
        try {
            return new ShortMessage(status, data1, data2);
        }
        catch (InvalidMidiDataException ex) {
            this.model.error("Invalid MIDI data.", ex);
            return null;
        }
    }

    private final class InternalMidiReceiver
    implements Receiver {
        private MidiMessageHandler callback;

        InternalMidiReceiver(MidiConnection midiConnection, MidiMessageHandler callback) {
            this.callback = callback;
        }

        @Override
        public void close() {
            this.callback = null;
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            if (this.callback != null) {
                this.callback.handleMidiMessage(message, timeStamp);
            }
        }
    }
}

