/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import de.mossgrabers.reaper.ui.utils.LogModel;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class BaseSetting<C extends JComponent, T>
implements IfxSetting {
    private final JLabel labelWidget;
    private final String label;
    private final String category;
    protected final LogModel logModel;
    protected final C field;
    protected final Set<IValueObserver<T>> observers = new HashSet<IValueObserver<T>>();

    protected BaseSetting(LogModel logModel, String label, String category, C field) {
        this.logModel = logModel;
        this.label = label;
        this.category = category;
        this.field = field;
        this.labelWidget = new JLabel(this.label);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getID() {
        return StringUtils.fixASCII((this.category + '_' + this.label).toUpperCase(Locale.US)).replace(' ', '_').replace('?', '_');
    }

    @Override
    public JLabel getLabelWidget() {
        return this.labelWidget;
    }

    @Override
    public JComponent getWidget() {
        return this.field;
    }

    protected void notifyObservers(T value) {
        for (IValueObserver<T> observer : this.observers) {
            observer.update(value);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.labelWidget.setEnabled(enable);
        ((JComponent)this.field).setEnabled(enable);
    }

    @Override
    public void setVisible(boolean visible) {
        this.labelWidget.setVisible(visible);
        ((JComponent)this.field).setVisible(visible);
    }
}

