/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum Views {
    PLAY,
    CHORDS,
    SESSION,
    SEQUENCER,
    DRUM,
    RAINDROPS,
    PIANO,
    PRG_CHANGE,
    CLIP_LENGTH,
    DRUM_XOX,
    DRUM4,
    DRUM8,
    DRUM64,
    COLOR,
    SCENE_PLAY,
    POLY_SEQUENCER,
    BROWSER,
    TRACK,
    TRACK_VOLUME,
    TRACK_PAN,
    TRACK_SENDS,
    TRACK_SELECT,
    TRACK_SOLO,
    TRACK_MUTE,
    DEVICE,
    CONTROL,
    SHIFT,
    USER,
    REPEAT_NOTE,
    NOTE_EDIT_VIEW,
    MIX,
    TEMPO,
    SHUFFLE,
    PROJECT,
    DUMMY1,
    DUMMY2,
    DUMMY3,
    DUMMY4,
    DUMMY5,
    DUMMY6;

    public static final String NAME_PLAY = "Play";
    public static final String NAME_CHORDS = "Chords";
    public static final String NAME_PIANO = "Piano";
    public static final String NAME_DRUM = "Drum";
    public static final String NAME_DRUM_XOX = "Drum XoX";
    public static final String NAME_DRUM4 = "Drum 4";
    public static final String NAME_DRUM8 = "Drum 8";
    public static final String NAME_DRUM64 = "Drum 64";
    public static final String NAME_SCENE_PLAY = "Scene Play";
    public static final String NAME_SEQUENCER = "Sequencer";
    public static final String NAME_RAINDROPS = "Raindrop";
    public static final String NAME_POLY_SEQUENCER = "Poly Seq.";
    public static final String NAME_BROWSER = "Browser";
    public static final String NAME_MIX = "Mix";
    public static final String NAME_SESSION = "Session";
    public static final String NAME_CLIP_LENGTH = "Clip Length";
    private static final Map<String, Views> VIEW_NAMES;
    private static final List<Views> NOTE_VIEWS;
    private static final Set<Views> SEQUENCER_VIEWS;
    private static final Set<Views> SESSION_VIEWS;
    private static boolean isInitialised;

    public static void init() {
        if (isInitialised) {
            return;
        }
        isInitialised = true;
        NOTE_VIEWS.add(PLAY);
        NOTE_VIEWS.add(CHORDS);
        NOTE_VIEWS.add(PIANO);
        NOTE_VIEWS.add(DRUM64);
        VIEW_NAMES.put(NAME_PLAY, PLAY);
        VIEW_NAMES.put(NAME_CHORDS, CHORDS);
        VIEW_NAMES.put(NAME_PIANO, PIANO);
        VIEW_NAMES.put(NAME_DRUM64, DRUM64);
        VIEW_NAMES.put(NAME_MIX, MIX);
        VIEW_NAMES.put(NAME_SESSION, SESSION);
        VIEW_NAMES.put(NAME_CLIP_LENGTH, CLIP_LENGTH);
        NOTE_VIEWS.add(DRUM);
        NOTE_VIEWS.add(DRUM4);
        NOTE_VIEWS.add(DRUM8);
        NOTE_VIEWS.add(DRUM_XOX);
        VIEW_NAMES.put(NAME_DRUM, DRUM);
        VIEW_NAMES.put(NAME_DRUM4, DRUM4);
        VIEW_NAMES.put(NAME_DRUM8, DRUM8);
        VIEW_NAMES.put(NAME_DRUM_XOX, DRUM_XOX);
        SEQUENCER_VIEWS.add(DRUM);
        SEQUENCER_VIEWS.add(DRUM4);
        SEQUENCER_VIEWS.add(DRUM8);
        NOTE_VIEWS.add(SEQUENCER);
        NOTE_VIEWS.add(RAINDROPS);
        NOTE_VIEWS.add(POLY_SEQUENCER);
        VIEW_NAMES.put(NAME_SEQUENCER, SEQUENCER);
        VIEW_NAMES.put(NAME_RAINDROPS, RAINDROPS);
        VIEW_NAMES.put(NAME_POLY_SEQUENCER, POLY_SEQUENCER);
        SEQUENCER_VIEWS.add(SEQUENCER);
        SEQUENCER_VIEWS.add(RAINDROPS);
        SEQUENCER_VIEWS.add(POLY_SEQUENCER);
        SESSION_VIEWS.add(SESSION);
        SESSION_VIEWS.add(SCENE_PLAY);
    }

    public static boolean isSequencerView(Views viewId) {
        return SEQUENCER_VIEWS.contains((Object)viewId);
    }

    public static boolean isSessionView(Views viewId) {
        return SESSION_VIEWS.contains((Object)viewId);
    }

    public static boolean isNoteView(Views viewId) {
        return NOTE_VIEWS.contains((Object)viewId);
    }

    public static Views getViewByName(String name) {
        return VIEW_NAMES.get(name);
    }

    public static String getViewName(Views view) {
        for (Map.Entry<String, Views> e : VIEW_NAMES.entrySet()) {
            if (e.getValue() != view) continue;
            return e.getKey();
        }
        return "Missing view name";
    }

    public static void setViewName(Views view, String name) {
        String key = null;
        for (Map.Entry<String, Views> e : VIEW_NAMES.entrySet()) {
            if (e.getValue() != view) continue;
            key = e.getKey();
            break;
        }
        if (key != null) {
            VIEW_NAMES.remove(key);
        }
        VIEW_NAMES.put(name, view);
    }

    public static Views get(Views view, int offset) {
        return Views.values()[view.ordinal() + offset];
    }

    static {
        VIEW_NAMES = new HashMap<String, Views>();
        NOTE_VIEWS = new ArrayList<Views>();
        SEQUENCER_VIEWS = new HashSet<Views>();
        SESSION_VIEWS = new HashSet<Views>();
        isInitialised = false;
    }
}

