/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.ISessionAlternative;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.FrameworkException;
import de.mossgrabers.framework.utils.Pair;

public abstract class AbstractSessionView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C>
implements ISessionAlternative {
    public static final String COLOR_SCENE = "COLOR_SCENE";
    public static final String COLOR_SELECTED_SCENE = "COLOR_SELECTED_SCENE";
    public static final String COLOR_SCENE_OFF = "COLOR_SELECTED_OFF";
    protected LightInfo clipColorIsRecording = new LightInfo(0, -1, false);
    protected LightInfo clipColorIsRecordingQueued = new LightInfo(1, -1, false);
    protected LightInfo clipColorIsPlaying = new LightInfo(2, -1, false);
    protected LightInfo clipColorIsPlayingQueued = new LightInfo(3, -1, false);
    protected LightInfo clipColorIsStopQueued = new LightInfo(3, -1, false);
    protected LightInfo clipColorHasContent = new LightInfo(4, -1, false);
    protected LightInfo clipColorHasNoContent = new LightInfo(5, -1, false);
    protected LightInfo clipColorIsRecArmed = new LightInfo(6, -1, false);
    protected LightInfo clipColorIsMuted = new LightInfo(7, -1, false);
    protected LightInfo birdColorHasContent = new LightInfo(4, -1, false);
    protected LightInfo birdColorSelected = new LightInfo(2, -1, false);
    protected int rows;
    protected int columns;
    protected boolean useClipColor;
    protected boolean ignoreClipColorForPlayAndRecord = false;
    protected ISlot sourceSlot;
    protected boolean isBirdsEyeActive = false;
    private boolean wasAlternateInteractionUsed = false;

    protected AbstractSessionView(String name, S surface, IModel model, int rows, int columns, boolean useClipColor) {
        super(name, surface, model);
        this.rows = rows;
        this.columns = columns;
        this.useClipColor = useClipColor;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (ButtonID.isSceneButton(buttonID)) {
            this.onSceneButton(buttonID, event);
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        boolean isPressed;
        Pair<Integer, Integer> padPos;
        boolean isAlternateFunction = this.isAlternateFunction();
        if (isAlternateFunction) {
            this.wasAlternateInteractionUsed = true;
        }
        if ((padPos = this.getPad(note)) == null) {
            return;
        }
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(padPos.getKey());
        ISlot slot = (ISlot)track.getSlotBank().getItem(padPos.getValue());
        boolean bl = isPressed = velocity != 0;
        if (isPressed) {
            if (this.handleButtonCombinations(track, slot)) {
                this.surface.consumePads();
                return;
            }
            if (this.doSelectClipOnLaunch()) {
                slot.select();
            }
        }
        if (!track.isRecArm() || slot.hasContent()) {
            slot.launch(isPressed, isAlternateFunction);
            return;
        }
        this.handleRecording(track, slot);
    }

    protected boolean isAlternateFunction() {
        return this.surface.isShiftPressed();
    }

    protected void handleRecording(ITrack track, ISlot slot) {
        Object configuration = this.surface.getConfiguration();
        switch (configuration.getActionForRecArmedPad()) {
            case 0: {
                this.model.recordNoteClip(track, slot);
                break;
            }
            case 1: {
                int lengthInBeats = configuration.getNewClipLenghthInBeats(this.model.getTransport().getQuartersPerMeasure());
                this.model.createNoteClip(track, slot, lengthInBeats, true);
                break;
            }
        }
    }

    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        if (!track.doesExist()) {
            return true;
        }
        if (this.isDeletePressed()) {
            if (slot.doesExist()) {
                slot.remove();
            }
            return true;
        }
        if (this.isDuplicatePressed()) {
            if (slot.doesExist() && slot.hasContent()) {
                this.sourceSlot = slot;
            } else if (this.sourceSlot != null) {
                slot.paste(this.sourceSlot);
            }
            return true;
        }
        if (this.isButtonCombination(ButtonID.STOP_CLIP)) {
            track.stop(this.isAlternateFunction());
            return true;
        }
        if (this.isButtonCombination(ButtonID.BROWSE)) {
            this.model.getBrowser().replace(slot);
            return true;
        }
        return false;
    }

    protected boolean isDeletePressed() {
        return this.isButtonCombination(ButtonID.DELETE);
    }

    protected boolean isDuplicatePressed() {
        return this.isButtonCombination(ButtonID.DUPLICATE);
    }

    protected void onGridNoteBirdsEyeView(int x, int y, int yOffset) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        ISceneBank sceneBank = tb.getSceneBank();
        boolean flip = this.surface.getConfiguration().isFlipSession();
        int numTracks = tb.getPageSize();
        int numScenes = sceneBank.getPageSize();
        int trackPosition = ((ITrack)tb.getItem(0)).getPosition() / numTracks;
        int scenePosition = sceneBank.getScrollPosition() / numScenes;
        int selX = flip ? scenePosition : trackPosition;
        int selY = flip ? trackPosition : scenePosition;
        int padsX = flip ? this.rows : this.columns;
        int padsY = flip ? this.columns : this.rows + yOffset;
        int offsetX = selX / padsX * padsX;
        int offsetY = selY / padsY * padsY;
        tb.scrollTo(offsetX * numTracks + (flip ? y : x) * padsX);
        sceneBank.scrollTo(offsetY * numScenes + (flip ? x : y) * padsY);
    }

    @Override
    public void drawGrid() {
        if (this.isBirdsEyeActive()) {
            this.drawBirdsEyeGrid();
        } else {
            this.drawSessionGrid();
        }
    }

    public void toggleBirdsEyeView() {
        this.isBirdsEyeActive = !this.isBirdsEyeActive;
    }

    public void setBirdsEyeActive(boolean isBirdsEyeActive) {
        this.isBirdsEyeActive = isBirdsEyeActive;
    }

    public boolean isBirdsEyeActive() {
        return this.isBirdsEyeActive;
    }

    @Override
    public boolean wasAlternateInteractionUsed() {
        return this.wasAlternateInteractionUsed;
    }

    @Override
    public void setAlternateInteractionUsed(boolean wasUsed) {
        this.wasAlternateInteractionUsed = wasUsed;
    }

    protected void drawSessionGrid() {
        this.drawSessionGrid(false);
    }

    protected void drawSessionGrid(boolean ignoreFlipCheck) {
        boolean flipSession = this.surface.getConfiguration().isFlipSession();
        if (flipSession && this.columns != this.rows && !ignoreFlipCheck) {
            throw new FrameworkException("Session flip is only supported for same size of rows and columns!");
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int x = 0; x < this.columns; ++x) {
            ITrack t = (ITrack)tb.getItem(x);
            ISlotBank slotBank = t.getSlotBank();
            for (int y = 0; y < this.rows; ++y) {
                this.drawPad((ISlot)slotBank.getItem(y), flipSession ? y : x, flipSession ? x : y, t.isRecArm());
            }
        }
    }

    protected void drawBirdsEyeGrid() {
        ITrackBank tb = this.model.getCurrentTrackBank();
        ISceneBank sceneBank = this.model.getSceneBank();
        int numTracks = tb.getPageSize();
        int numScenes = sceneBank.getPageSize();
        int sceneCount = sceneBank.getItemCount();
        int trackCount = tb.getItemCount();
        int maxScenePads = sceneCount / numScenes + (sceneCount % numScenes > 0 ? 1 : 0);
        int maxTrackPads = trackCount / numTracks + (trackCount % numTracks > 0 ? 1 : 0);
        int scenePosition = sceneBank.getScrollPosition();
        int trackPosition = ((ITrack)tb.getItem(0)).getPosition();
        int sceneSelection = scenePosition / numScenes + (scenePosition % numScenes > 0 ? 1 : 0);
        int trackSelection = trackPosition / numTracks + (trackPosition % numTracks > 0 ? 1 : 0);
        boolean flipSession = this.surface.getConfiguration().isFlipSession();
        int selX = flipSession ? sceneSelection : trackSelection;
        int selY = flipSession ? trackSelection : sceneSelection;
        int padsX = flipSession ? this.rows : this.columns;
        int padsY = flipSession ? this.columns : this.rows;
        int offsetX = selX / padsX * padsX;
        int offsetY = selY / padsY * padsY;
        int maxX = (flipSession ? maxScenePads : maxTrackPads) - offsetX;
        int maxY = (flipSession ? maxTrackPads : maxScenePads) - offsetY;
        selX -= offsetX;
        selY -= offsetY;
        IPadGrid padGrid = this.surface.getPadGrid();
        for (int x = 0; x < this.columns; ++x) {
            LightInfo rowColor = x < maxX ? this.birdColorHasContent : this.clipColorHasNoContent;
            for (int y = 0; y < this.rows; ++y) {
                LightInfo color;
                LightInfo lightInfo = color = y < maxY ? rowColor : this.clipColorHasNoContent;
                if (selX == x && selY == y) {
                    color = this.birdColorSelected;
                }
                padGrid.lightEx(x, y, color.getColor(), color.getBlinkColor(), color.isFast());
            }
        }
    }

    protected void setColors(LightInfo isRecording, LightInfo isRecordingQueued, LightInfo isPlaying, LightInfo isPlayingQueued, LightInfo isStopQueued, LightInfo hasContent, LightInfo noContent, LightInfo recArmed, LightInfo isMuted) {
        this.clipColorIsRecording = isRecording;
        this.clipColorIsRecordingQueued = isRecordingQueued;
        this.clipColorIsPlaying = isPlaying;
        this.clipColorIsPlayingQueued = isPlayingQueued;
        this.clipColorIsStopQueued = isStopQueued;
        this.clipColorHasContent = hasContent;
        this.clipColorHasNoContent = noContent;
        this.clipColorIsRecArmed = recArmed;
        this.clipColorIsMuted = isMuted;
    }

    protected boolean doSelectClipOnLaunch() {
        return this.surface.getConfiguration().isSelectClipOnLaunch();
    }

    protected void drawPad(ISlot slot, int x, int y, boolean isArmed) {
        LightInfo color = this.getPadColor(slot, isArmed);
        this.surface.getPadGrid().lightEx(x, y + this.getYOffset(), color.getColor(), color.getBlinkColor(), color.isFast());
    }

    protected int getYOffset() {
        return 0;
    }

    public LightInfo getPadColor(ISlot slot, boolean isArmed) {
        String colorID = DAWColor.getColorID(slot.getColor());
        ColorManager cm = this.model.getColorManager();
        if (slot.isRecordingQueued()) {
            return this.clipColorIsRecordingQueued;
        }
        if (slot.isRecording()) {
            return this.insertClipColor(cm, colorID, this.clipColorIsRecording);
        }
        if (slot.isPlayingQueued()) {
            return this.insertClipColor(cm, colorID, this.clipColorIsPlayingQueued);
        }
        if (slot.isStopQueued()) {
            return this.insertClipColor(cm, colorID, this.clipColorIsStopQueued);
        }
        if (slot.isPlaying()) {
            return this.insertClipColor(cm, colorID, this.clipColorIsPlaying);
        }
        if (slot.hasContent()) {
            if (slot.isMuted()) {
                return new LightInfo(this.clipColorIsMuted.getColor(), -1, false);
            }
            int blinkColor = this.clipColorHasContent.getBlinkColor();
            int color = this.useClipColor && colorID != null ? cm.getColorIndex(colorID) : this.clipColorHasContent.getColor();
            return new LightInfo(color, slot.isSelected() ? blinkColor : -1, this.clipColorHasContent.isFast());
        }
        return slot.doesExist() && isArmed && this.surface.getConfiguration().isDrawRecordStripe() ? this.clipColorIsRecArmed : this.clipColorHasNoContent;
    }

    protected Pair<Integer, Integer> getPad(int note) {
        int index = note - this.surface.getPadGrid().getStartNote();
        int t = index % this.columns;
        int s = this.rows - 1 - index / this.columns;
        Object configuration = this.surface.getConfiguration();
        return configuration.isFlipSession() ? new Pair<Integer, Integer>(s, t) : new Pair<Integer, Integer>(t, s);
    }

    private LightInfo insertClipColor(ColorManager colorManager, String colorID, LightInfo lightInfo) {
        int blinkColor;
        if (this.useClipColor && !this.ignoreClipColorForPlayAndRecord && colorID != null && (blinkColor = lightInfo.getBlinkColor()) > 0) {
            return new LightInfo(colorManager.getColorIndex(colorID), blinkColor, lightInfo.isFast());
        }
        return lightInfo;
    }
}

