/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameterprovider.track;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.data.empty.EmptySend;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameterprovider.track.AbstractTrackParameterProvider;
import java.util.Optional;

public class SendParameterProvider
extends AbstractTrackParameterProvider
implements IItemSelectionObserver {
    private final int sendIndex;
    private final int sendOffset;

    public SendParameterProvider(IModel model, int sendIndex, int sendOffset) {
        super(model);
        this.sendIndex = sendIndex;
        this.sendOffset = sendOffset;
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        super.addParametersObserver(observer);
        if (this.sendIndex == -1) {
            this.bank.addSelectionObserver(this);
        } else {
            int i;
            ITrackBank trackBank = this.model.getTrackBank();
            for (i = 0; i < trackBank.getPageSize(); ++i) {
                ((ITrack)trackBank.getItem(i)).getSendBank().addPageObserver(this);
            }
            trackBank = this.model.getEffectTrackBank();
            if (trackBank != null) {
                for (i = 0; i < trackBank.getPageSize(); ++i) {
                    ((ITrack)trackBank.getItem(i)).getSendBank().addPageObserver(this);
                }
            }
        }
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        if (this.sendIndex == -1) {
            this.bank.removeSelectionObserver(this);
        } else {
            int i;
            ITrackBank trackBank = this.model.getTrackBank();
            for (i = 0; i < trackBank.getPageSize(); ++i) {
                ((ITrack)trackBank.getItem(i)).getSendBank().removePageObserver(this);
            }
            trackBank = this.model.getEffectTrackBank();
            if (trackBank != null) {
                for (i = 0; i < trackBank.getPageSize(); ++i) {
                    ((ITrack)trackBank.getItem(i)).getSendBank().removePageObserver(this);
                }
            }
        }
        super.removeParametersObserver(observer);
    }

    @Override
    public ISend get(int index) {
        if (this.sendIndex == -1) {
            Optional track = this.bank.getSelectedItem();
            if (track.isEmpty()) {
                return EmptySend.INSTANCE;
            }
            int idx = this.sendOffset + index;
            ISendBank sendBank = ((ITrack)track.get()).getSendBank();
            return idx < sendBank.getItemCount() ? (ISend)sendBank.getItem(idx) : EmptySend.INSTANCE;
        }
        ISendBank sendBank = ((ITrack)this.bank.getItem(index)).getSendBank();
        int idx = this.sendOffset + this.sendIndex;
        return sendBank.getItemCount() == 0 ? EmptySend.INSTANCE : (ISend)sendBank.getItem(idx);
    }

    @Override
    public Optional<ColorEx> getColor(int index) {
        return Optional.ofNullable(this.get(index).getColor());
    }

    @Override
    public void call(int index, boolean isSelected) {
        this.notifyParametersObservers();
    }
}

