/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.track;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class TrackVolumeMode<S extends IControlSurface<C>, C extends Configuration>
extends DefaultTrackMode<S, C> {
    public TrackVolumeMode(S surface, IModel model, boolean isAbsolute) {
        this(surface, model, isAbsolute, null);
    }

    public TrackVolumeMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls) {
        this(surface, model, isAbsolute, controls, () -> surface.isShiftPressed());
    }

    public TrackVolumeMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> controls, BooleanSupplier isAlternativeFunction) {
        super("Volume", surface, model, isAbsolute, controls, isAlternativeFunction);
        if (controls != null) {
            this.setParameterProvider(new VolumeParameterProvider(model));
        }
    }

    @Override
    public void onKnobValue(int index, int value) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isEmpty()) {
            return;
        }
        ITrack t = track.get();
        if (this.isAbsolute) {
            t.setVolume(value);
        } else {
            t.changeVolume(value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        Optional<ITrack> track = this.getTrack(index);
        if (track.isEmpty()) {
            return;
        }
        ITrack t = track.get();
        if (isTouched && this.surface.isDeletePressed()) {
            t.resetVolume();
        }
        t.touchVolume(isTouched);
    }

    @Override
    public int getKnobValue(int index) {
        Optional<ITrack> track = this.getTrack(index);
        return track.isEmpty() ? -1 : track.get().getVolume();
    }
}

