/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.ChannelSelectComponent;
import de.mossgrabers.framework.graphics.canvas.utils.SendData;
import java.util.Arrays;

public class SendsComponent
extends ChannelSelectComponent {
    private final SendData[] sendData;
    private final boolean isExMode;
    private final boolean isSendActive;

    public SendsComponent(SendData[] sendData, String menuName, boolean isMenuSelected, String name, ColorEx color, boolean isSelected, ChannelType type, boolean isExMode, boolean isSendActive, boolean isChannelLabelActive) {
        super(type, menuName, isMenuSelected, name, color, isSelected, isChannelLabelActive);
        this.sendData = sendData;
        this.isExMode = isExMode;
        this.isSendActive = isSendActive;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        SendData send;
        String sendName;
        double h;
        super.draw(info);
        String name = this.footer.getText();
        if (!(name != null && name.length() != 0 || this.isExMode)) {
            return;
        }
        IGraphicsContext gc = info.getContext();
        IGraphicsDimensions dimensions = info.getDimensions();
        IGraphicsConfiguration configuration = info.getConfiguration();
        double left = info.getBounds().left();
        double width = info.getBounds().width();
        double height = info.getBounds().height();
        double separatorSize = dimensions.getSeparatorSize();
        double menuHeight = dimensions.getMenuHeight();
        double unit = dimensions.getUnit();
        double inset = dimensions.getInset();
        int trackRowHeight = (int)(1.6 * unit);
        double trackRowTop = height - (double)trackRowHeight - unit - separatorSize;
        double sliderWidth = width - 2.0 * inset - 1.0;
        double t = menuHeight + 1.0;
        double sliderAreaHeight = h = trackRowTop - t;
        double sendRowHeight = sliderAreaHeight / 8.0;
        double sliderHeight = sendRowHeight - 2.0 * separatorSize;
        ColorEx backgroundColor = this.modifyIfOff(true, configuration.getColorBackground());
        gc.fillRectangle(this.isExMode ? left - separatorSize : left, t, this.isExMode ? width + separatorSize : width, this.isExMode ? h - 2.0 : h, this.footer.isSelected() || this.isExMode ? this.modifyIfOff(true, configuration.getColorBackgroundLighter()) : backgroundColor);
        double topy = menuHeight + (this.isExMode ? 0.0 : separatorSize);
        double faderLeft = left + inset;
        SendData[] sendDataArray = this.sendData;
        int n = sendDataArray.length;
        for (int i = 0; i < n && (sendName = (send = sendDataArray[i]).name()).length() != 0; ++i) {
            ColorEx textColor = this.modifyIfOff(send.enabled(), configuration.getColorText());
            ColorEx borderColor = this.modifyIfOff(send.enabled(), configuration.getColorBorder());
            ColorEx faderColor = this.modifyIfOff(send.enabled(), configuration.getColorFader());
            ColorEx editColor = this.modifyIfOff(send.enabled(), configuration.getColorEdit());
            gc.drawTextInBounds(sendName, faderLeft, topy + separatorSize, sliderWidth, sendRowHeight, Align.LEFT, textColor, sendRowHeight);
            gc.fillRectangle(faderLeft, (topy += sendRowHeight) + separatorSize, sliderWidth, sliderHeight, borderColor);
            double valueWidth = (double)send.value() * sliderWidth / (double)dimensions.getParameterUpperBound();
            int modulatedValue = send.modulatedValue();
            boolean isSendModulated = modulatedValue != -1;
            double modulatedValueWidth = isSendModulated ? (double)modulatedValue * sliderWidth / (double)dimensions.getParameterUpperBound() : valueWidth;
            double faderTop = topy + separatorSize + 1.0;
            gc.fillRectangle(faderLeft + 1.0, faderTop, modulatedValueWidth - 1.0, sliderHeight - 2.0, faderColor);
            String text = send.text();
            if (send.edited()) {
                boolean isTouched = text != null && text.length() > 0;
                double w = isTouched ? 3.0 : 1.0;
                gc.fillRectangle(Math.min(faderLeft + sliderWidth - w - 1.0, faderLeft + valueWidth + 1.0), faderTop, w, sliderHeight - 2.0, editColor);
            }
            topy += sendRowHeight;
        }
        double boxWidth = sliderWidth / 2.0;
        double boxLeft = faderLeft + sliderWidth - boxWidth;
        topy = menuHeight;
        ColorEx backgroundDarker = this.modifyIfOff(true, configuration.getColorBackgroundDarker());
        for (SendData send2 : this.sendData) {
            topy += sendRowHeight;
            String text = send2.text();
            if (text.length() > 0) {
                ColorEx textColor = this.modifyIfOff(send2.enabled(), configuration.getColorText());
                ColorEx borderColor = this.modifyIfOff(send2.enabled(), configuration.getColorBorder());
                double volumeTextTop = topy + sliderHeight + 1.0 + (this.isExMode ? 0.0 : separatorSize);
                gc.fillRectangle(boxLeft, volumeTextTop, boxWidth, unit, backgroundDarker);
                gc.strokeRectangle(boxLeft, volumeTextTop, boxWidth - 1.0, unit, borderColor);
                gc.drawTextInBounds(text, boxLeft, volumeTextTop, boxWidth, unit, Align.CENTER, textColor, unit);
            }
            topy += sendRowHeight;
        }
    }

    protected ColorEx modifyIfOff(boolean isEnabled, ColorEx color) {
        return this.isSendActive && isEnabled ? color : ColorEx.dimToGray(color);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isExMode ? 1231 : 1237);
        result = 31 * result + (this.isSendActive ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.sendData);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        SendsComponent other = (SendsComponent)obj;
        if (this.isExMode != other.isExMode || this.isSendActive != other.isSendActive) {
            return false;
        }
        return Arrays.equals(this.sendData, other.sendData);
    }
}

