/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.featuregroup;

import de.mossgrabers.framework.featuregroup.FeatureGroupChangeListener;
import de.mossgrabers.framework.featuregroup.IFeatureGroup;
import de.mossgrabers.framework.utils.FrameworkException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class FeatureGroupManager<E extends Enum<E>, F extends IFeatureGroup> {
    protected final Map<E, F> featureGroups;
    protected E activeID = null;
    protected E previousID = null;
    protected E temporaryID = null;
    protected E defaultID = null;
    private final List<FeatureGroupChangeListener<E>> changeListeners = new ArrayList<FeatureGroupChangeListener<E>>();
    private final List<FeatureGroupManager<E, F>> connectedManagers = new ArrayList<FeatureGroupManager<E, F>>();

    public FeatureGroupManager(Class<E> clazz) {
        this.featureGroups = new EnumMap<E, F>(clazz);
    }

    public void register(E featureGroupId, F featureGroup) {
        this.featureGroups.put(featureGroupId, featureGroup);
    }

    public F get(E featureGroupId) {
        return (F)((IFeatureGroup)this.featureGroups.get(featureGroupId));
    }

    public E get(String featureGroupName) {
        for (Map.Entry<E, F> entry : this.featureGroups.entrySet()) {
            if (!featureGroupName.equals(((IFeatureGroup)entry.getValue()).getName())) continue;
            return (E)((Enum)entry.getKey());
        }
        return null;
    }

    public boolean isTemporary() {
        return this.temporaryID != null;
    }

    public void setActive(E featureGroupID) {
        this.setActive(featureGroupID, true);
    }

    private void setActive(E featureGroupID, boolean syncSiblings) {
        Object id;
        Object e = id = featureGroupID == null ? this.defaultID : featureGroupID;
        if (id == null) {
            throw new FrameworkException("Attempt to set the active feature group to null and no default feature group is registered.");
        }
        if (this.isActive(new Enum[]{id})) {
            return;
        }
        F deactivate = this.getActive();
        if (deactivate != null) {
            deactivate.onDeactivate();
        }
        this.temporaryID = null;
        this.previousID = this.activeID;
        this.activeID = id;
        this.get(this.activeID).onActivate();
        if (syncSiblings) {
            this.connectedManagers.forEach(sibling -> sibling.setActive(featureGroupID, false));
        }
        this.notifyObservers(this.previousID, this.activeID);
    }

    public void setTemporary(E featureGroupID) {
        this.setTemporary(featureGroupID, true);
    }

    private void setTemporary(E featureGroupID, boolean syncSiblings) {
        if (featureGroupID == null) {
            throw new FrameworkException("Attempt to set the temporary feature group to null.");
        }
        if (this.isActive(new Enum[]{featureGroupID})) {
            return;
        }
        F deactivate = this.getActive();
        if (deactivate != null) {
            deactivate.onDeactivate();
        }
        this.temporaryID = featureGroupID;
        F featureGroup = this.get(this.temporaryID);
        if (featureGroup == null) {
            throw new FrameworkException("Attempt to set the temporary feature group to non-existing: " + String.valueOf(featureGroupID));
        }
        featureGroup.onActivate();
        if (syncSiblings) {
            this.connectedManagers.forEach(sibling -> sibling.setActive(featureGroupID, false));
        }
        this.notifyObservers(this.activeID, this.temporaryID);
    }

    @SafeVarargs
    public final boolean isActive(E ... featureGroupIDs) {
        E id = this.getActiveID();
        for (E featureGroupID : featureGroupIDs) {
            if (id != featureGroupID) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean isActiveIgnoreTemporary(E ... featureGroupIDs) {
        E id = this.getActiveIDIgnoreTemporary();
        for (E featureGroupID : featureGroupIDs) {
            if (id != featureGroupID) continue;
            return true;
        }
        return false;
    }

    public E getActiveID() {
        return this.temporaryID == null ? this.activeID : this.temporaryID;
    }

    public E getActiveIDIgnoreTemporary() {
        return this.activeID;
    }

    public F getActive() {
        E featureGroupID = this.getActiveID();
        return (F)(featureGroupID == null ? null : (IFeatureGroup)this.featureGroups.get(featureGroupID));
    }

    public void setDefaultID(E featureGroupID) {
        this.defaultID = featureGroupID;
    }

    public E getPreviousID() {
        return this.previousID;
    }

    public void setPreviousID(E featureGroupID) {
        this.setPrevious(featureGroupID, true);
    }

    private void setPrevious(E featureGroupID, boolean syncSiblings) {
        this.previousID = featureGroupID;
        if (syncSiblings) {
            this.connectedManagers.forEach(sibling -> sibling.setPrevious(featureGroupID, false));
        }
    }

    public F getPrevious() {
        return this.previousID == null ? null : (F)this.get(this.previousID);
    }

    public void restore() {
        this.restore(true);
    }

    private void restore(boolean syncSiblings) {
        E oldID = null;
        if (this.temporaryID != null) {
            oldID = this.temporaryID;
            this.get(this.temporaryID).onDeactivate();
            this.temporaryID = null;
            F featureGroup = this.get(this.activeID);
            if (featureGroup == null) {
                this.activeID = this.defaultID;
                featureGroup = this.get(this.activeID);
            }
            featureGroup.onActivate();
        } else if (this.previousID != null) {
            oldID = this.activeID;
            this.get(this.activeID).onDeactivate();
            this.activeID = this.previousID;
            F featureGroup = this.get(this.activeID);
            if (featureGroup == null) {
                this.activeID = this.defaultID;
                featureGroup = this.get(this.activeID);
            }
            featureGroup.onActivate();
        }
        if (syncSiblings) {
            this.connectedManagers.forEach(sibling -> sibling.restore(false));
        }
        if (oldID != null) {
            this.notifyObservers(oldID, this.activeID);
        }
    }

    public void addConnectedManagerListener(FeatureGroupManager<E, F> sibling) {
        this.connectedManagers.add(sibling);
    }

    public void addChangeListener(FeatureGroupChangeListener<E> listener) {
        this.changeListeners.add(listener);
    }

    protected void notifyObservers(E oldFeatureGroup, E newFeatureGroup) {
        this.changeListeners.forEach(l -> l.call(oldFeatureGroup, newFeatureGroup));
    }

    public List<FeatureGroupManager<E, F>> getConnectedManagers() {
        return this.connectedManagers;
    }
}

