/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.featuregroup;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractFeatureGroup;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Arrays;
import java.util.Optional;

public abstract class AbstractMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractFeatureGroup<S, C>
implements IMode {
    public static final String BUTTON_COLOR_HI = "BUTTON_COLOR_HI";
    public static final String BUTTON_COLOR2_ON = "BUTTON_COLOR2_ON";
    public static final String BUTTON_COLOR2_HI = "BUTTON_COLOR2_HI";
    protected boolean isAbsolute;
    protected boolean isActive;
    private boolean[] isKnobTouched;

    protected AbstractMode(String name, S surface, IModel model, boolean isAbsolute) {
        super(name, surface, model);
        this.isAbsolute = isAbsolute;
    }

    @Override
    public void onActivate() {
        this.isActive = true;
    }

    @Override
    public void onDeactivate() {
        this.isActive = false;
    }

    @Override
    public void updateDisplay() {
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public void setAbsolute(boolean isAbsolute) {
        this.isAbsolute = isAbsolute;
    }

    @Override
    public void onKnobValue(int index, int value) {
    }

    @Override
    public int getKnobValue(int index) {
        return 0;
    }

    @Override
    public int getKnobColor(int index) {
        return 0;
    }

    public final void initTouchedStates(int size) {
        this.isKnobTouched = new boolean[size];
        Arrays.fill(this.isKnobTouched, false);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
    }

    @Override
    public void setTouchedKnob(int knobIndex, boolean isTouched) {
        this.isKnobTouched[knobIndex] = isTouched;
    }

    @Override
    public boolean isAnyKnobTouched() {
        for (boolean isTouched : this.isKnobTouched) {
            if (!isTouched) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getTouchedKnob() {
        for (int i = 0; i < this.isKnobTouched.length; ++i) {
            if (!this.isKnobTouched[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isKnobTouched(int index) {
        return index < this.isKnobTouched.length && this.isKnobTouched[index];
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
    }

    @Override
    public void selectItem(int index) {
    }

    @Override
    public Optional<String> getSelectedItemName() {
        return Optional.empty();
    }

    @Override
    public void selectPreviousItem() {
    }

    @Override
    public void selectNextItem() {
    }

    @Override
    public void selectPreviousItemPage() {
    }

    @Override
    public void selectNextItemPage() {
    }

    @Override
    public void selectItemPage(int page) {
    }

    @Override
    public boolean hasPreviousItem() {
        return false;
    }

    @Override
    public boolean hasNextItem() {
        return false;
    }

    @Override
    public boolean hasPreviousItemPage() {
        return false;
    }

    @Override
    public boolean hasNextItemPage() {
        return false;
    }

    @Override
    public String formatPageRange(String format) {
        return "";
    }

    @Override
    public IParameterProvider getParameterProvider() {
        return null;
    }

    protected int isButtonRow(int row, ButtonID buttonID) {
        int ordinal = buttonID.ordinal();
        if (row == 0 && ordinal >= ButtonID.ROW1_1.ordinal() && ordinal <= ButtonID.ROW1_8.ordinal()) {
            return ordinal - ButtonID.ROW1_1.ordinal();
        }
        if (row == 1 && ordinal >= ButtonID.ROW2_1.ordinal() && ordinal <= ButtonID.ROW2_8.ordinal()) {
            return ordinal - ButtonID.ROW2_1.ordinal();
        }
        if (row == 2 && ordinal >= ButtonID.ROW3_1.ordinal() && ordinal <= ButtonID.ROW3_8.ordinal()) {
            return ordinal - ButtonID.ROW3_1.ordinal();
        }
        if (row == 3 && ordinal >= ButtonID.ROW4_1.ordinal() && ordinal <= ButtonID.ROW4_8.ordinal()) {
            return ordinal - ButtonID.ROW4_1.ordinal();
        }
        if (row == 4 && ordinal >= ButtonID.ROW5_1.ordinal() && ordinal <= ButtonID.ROW5_8.ordinal()) {
            return ordinal - ButtonID.ROW5_1.ordinal();
        }
        if (row == 5 && ordinal >= ButtonID.ROW6_1.ordinal() && ordinal <= ButtonID.ROW6_8.ordinal()) {
            return ordinal - ButtonID.ROW6_1.ordinal();
        }
        return -1;
    }

    protected int getButtonRow(ButtonID buttonID) {
        int ordinal = buttonID.ordinal();
        if (ordinal >= ButtonID.ROW1_1.ordinal() && ordinal <= ButtonID.ROW1_8.ordinal()) {
            return 0;
        }
        if (ordinal >= ButtonID.ROW2_1.ordinal() && ordinal <= ButtonID.ROW2_8.ordinal()) {
            return 1;
        }
        if (ordinal >= ButtonID.ROW3_1.ordinal() && ordinal <= ButtonID.ROW3_8.ordinal()) {
            return 2;
        }
        if (ordinal >= ButtonID.ROW4_1.ordinal() && ordinal <= ButtonID.ROW4_8.ordinal()) {
            return 3;
        }
        if (ordinal >= ButtonID.ROW5_1.ordinal() && ordinal <= ButtonID.ROW5_8.ordinal()) {
            return 4;
        }
        if (ordinal >= ButtonID.ROW6_1.ordinal() && ordinal <= ButtonID.ROW6_8.ordinal()) {
            return 5;
        }
        return -1;
    }
}

