/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.midi;

import java.util.HashMap;
import java.util.Map;

public enum ArpeggiatorMode {
    ALL("All"),
    UP("Up"),
    UP_DOWN("Up/Down"),
    UP_THEN_DOWN("Up then Down"),
    DOWN("Down"),
    DOWN_UP("Down/Up"),
    DOWN_THEN_UP("Down then Up"),
    FLOW("Flow"),
    RANDOM("Random"),
    CONVERGE_UP("Converge Up"),
    CONVERGE_DOWN("Converge Down"),
    DIVERGE_UP("Diverge Up"),
    DIVERGE_DOWN("Diverge Down"),
    THUMB_UP("Thumb Up"),
    THUMB_DOWN("Thumb Down"),
    PINKY_UP("Pinky UP"),
    PINKY_DOWN("Pinky Down");

    private static final String[] NAMES;
    private static final Map<String, ArpeggiatorMode> NAME_MODE_MAP;
    private final String name;

    private ArpeggiatorMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static String[] getNames() {
        return NAMES;
    }

    public static ArpeggiatorMode lookup(String value) {
        return ArpeggiatorMode.valueOf(value);
    }

    public static ArpeggiatorMode lookupByName(String name) {
        return NAME_MODE_MAP.getOrDefault(name, ALL);
    }

    static {
        NAMES = new String[ArpeggiatorMode.values().length];
        NAME_MODE_MAP = new HashMap<String, ArpeggiatorMode>(ArpeggiatorMode.values().length);
        ArpeggiatorMode[] values = ArpeggiatorMode.values();
        for (int i = 0; i < values.length; ++i) {
            ArpeggiatorMode.NAMES[i] = values[i].getName();
            NAME_MODE_MAP.put(NAMES[i], values[i]);
        }
    }
}

