/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.data.bank;

import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.bank.AbstractBank;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractItemBank<T extends IItem>
extends AbstractBank<T> {
    protected AbstractItemBank(IHost host, int pageSize) {
        super(host, pageSize);
    }

    protected AbstractItemBank(IHost host, int pageSize, List<T> items) {
        super(host, pageSize, items);
    }

    @Override
    public boolean hasExistingItems() {
        for (int i = 0; i < this.getPageSize(); ++i) {
            if (!((IItem)this.getItem(i)).doesExist()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<T> getSelectedItem() {
        for (int i = 0; i < this.getPageSize(); ++i) {
            IItem item = (IItem)this.getItem(i);
            if (!item.isSelected()) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @Override
    public List<T> getSelectedItems() {
        ArrayList<IItem> selection = new ArrayList<IItem>();
        for (int i = 0; i < this.getPageSize(); ++i) {
            IItem item = (IItem)this.getItem(i);
            if (!item.isSelected()) continue;
            selection.add(item);
        }
        return selection;
    }

    @Override
    public void selectItemAtPosition(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return;
        }
        int ps = this.getPageSize();
        this.scrollTo(position / ps * ps);
        this.host.scheduleTask(() -> {
            ((IItem)this.getItem(position % ps)).select();
            this.firePageObserver();
        }, 75L);
    }

    @Override
    public int getScrollPosition() {
        return ((IItem)this.getItem(0)).getPosition();
    }

    @Override
    public int getPositionOfLastItem() {
        for (int i = this.getPageSize() - 1; i >= 0; --i) {
            int pos;
            IItem item = (IItem)this.getItem(i);
            if (!item.doesExist() || (pos = item.getPosition()) < 0) continue;
            return pos;
        }
        return -1;
    }

    @Override
    public boolean canScrollBackwards() {
        Optional<T> sel = this.getSelectedItem();
        int selIndex = sel.isPresent() ? ((IItem)sel.get()).getIndex() : -1;
        return selIndex > 0 || this.canScrollPageBackwards();
    }

    @Override
    public boolean canScrollForwards() {
        Optional<T> sel = this.getSelectedItem();
        int selIndex = sel.isPresent() ? ((IItem)sel.get()).getIndex() : -1;
        return selIndex >= 0 && selIndex < this.getPageSize() - 1 && ((IItem)this.getItem(selIndex + 1)).doesExist() || this.canScrollPageForwards();
    }
}

