/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.constants;

import java.util.HashMap;
import java.util.Map;

public enum Resolution {
    RES_1_4("1/4", 1.0),
    RES_1_4T("1/4t", 0.6666666666666666),
    RES_1_8("1/8", 0.5),
    RES_1_8T("1/8t", 0.3333333333333333),
    RES_1_16("1/16", 0.25),
    RES_1_16T("1/16t", 0.16666666666666666),
    RES_1_32("1/32", 0.125),
    RES_1_32T("1/32t", 0.08333333333333333);

    private static final String[] RESOLUTION_NAMES;
    private static final Map<String, Resolution> RESOLUTION_BY_NAME;
    private final String name;
    private final double value;

    private Resolution(String name, double value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public static double getValueAt(int index) {
        return Resolution.values()[index].getValue();
    }

    public static String getNameAt(int index) {
        return Resolution.values()[index].getName();
    }

    public static Resolution getByName(String name) {
        return RESOLUTION_BY_NAME.get(name);
    }

    public static boolean matches(int index, double value) {
        return Math.abs(value - Resolution.getValueAt(index)) < 0.001;
    }

    public static int getMatch(double value) {
        Resolution[] resolutions = Resolution.values();
        double min = 1.0;
        int result = 0;
        for (int i = 0; i < resolutions.length; ++i) {
            double diff = Math.abs(value - Resolution.getValueAt(i));
            if (!(diff < min)) continue;
            min = diff;
            result = i;
        }
        return result;
    }

    public static int change(int index, boolean inc) {
        return Math.max(0, Math.min(Resolution.values().length - 1, index + (inc ? 1 : -1)));
    }

    public static String[] getNames() {
        return RESOLUTION_NAMES;
    }

    static {
        RESOLUTION_BY_NAME = new HashMap<String, Resolution>();
        Resolution[] values = Resolution.values();
        RESOLUTION_NAMES = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Resolution.RESOLUTION_NAMES[i] = values[i].name;
            RESOLUTION_BY_NAME.put(RESOLUTION_NAMES[i], values[i]);
        }
    }
}

