/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.track;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class MonitorCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private int index;

    public MonitorCommand(IModel model, S surface) {
        this(-1, model, surface);
    }

    public MonitorCommand(int index, IModel model, S surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITrackBank currentTrackBank = this.model.getCurrentTrackBank();
        if (this.index == -1) {
            Optional selectedItem = currentTrackBank.getSelectedItem();
            if (selectedItem.isPresent()) {
                ((ITrack)selectedItem.get()).toggleMonitor();
            }
        } else {
            ((ITrack)currentTrackBank.getItem(this.index)).toggleMonitor();
        }
    }
}

