/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public abstract class AbstractDoubleTriggerCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private boolean restartFlag = false;

    protected AbstractDoubleTriggerCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP || this.handleButtonCombinations()) {
            return;
        }
        if (this.restartFlag) {
            this.executeDoubleClick();
            this.restartFlag = false;
            return;
        }
        this.executeSingleClick();
    }

    protected boolean handleButtonCombinations() {
        return false;
    }

    protected abstract void executeSingleClick();

    protected abstract void executeDoubleClick();

    protected void doubleClickTest() {
        this.restartFlag = true;
        this.surface.scheduleTask(() -> {
            this.restartFlag = false;
        }, 250L);
    }
}

