/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.view;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.controller.OxiOnePadGrid;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.view.sequencer.AbstractDrumXoXView;

public class OxiOneDrumXoXView
extends AbstractDrumXoXView<OxiOneControlSurface, OxiOneConfiguration> {
    protected static final int[] DRUM_MATRIX_LARGE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private final OxiOnePadGrid padGrid;
    private final int numRows;

    public OxiOneDrumXoXView(OxiOneControlSurface surface, IModel model) {
        super("Drum XoX", surface, model, 16, 96);
        this.drumMatrix = DRUM_MATRIX_LARGE;
        this.sequencerLines = 6;
        this.allRows = 6;
        this.sequencerSteps = 96;
        this.padGrid = ((OxiOneControlSurface)this.surface).getPadGrid();
        this.numRows = this.padGrid.getRows();
    }

    @Override
    public void onGridNoteLongPress(int note) {
        if (!this.isActive()) {
            return;
        }
        int index = note - this.padGrid.getStartNote();
        int x = index % this.numColumns;
        int y = index / this.numColumns;
        if (y < this.numStepRows) {
            ((OxiOneControlSurface)this.surface).getButton(ButtonID.get(ButtonID.PAD1, index)).setConsumed();
            int offsetY = this.scales.getDrumOffset();
            NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), (this.numStepRows - 1 - y) * this.numColumns + x, offsetY + this.selectedPad);
            this.editNote(this.getClip(), notePosition, false);
        }
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.REPEAT) || ((OxiOneControlSurface)this.surface).isPressed(ButtonID.ACCENT)) {
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, ((OxiOneControlSurface)this.surface).isPressed(ButtonID.REPEAT));
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }

    @Override
    public void drawGrid() {
        if (((OxiOneControlSurface)this.surface).isMutePressed()) {
            if (!this.isActive()) {
                this.padGrid.turnOff();
                return;
            }
            this.drawPages(this.getClip(), true);
            int black = this.model.getColorManager().getColorIndex("BUTTON_COLOR_OFF");
            IDrumDevice primary = this.getDrumDevice();
            boolean hasDrumPads = primary.hasDrumPads();
            IDrumPadBank drumPadBank = primary.getDrumPadBank();
            for (int sound = 0; sound < this.numColumns; ++sound) {
                IDrumPad drumPad = drumPadBank.getItem(sound);
                if (hasDrumPads && drumPad.doesExist()) {
                    start = 4;
                    String padColor = DAWColor.getColorID(drumPad.getColor());
                    this.padGrid.lightEx(sound, 1, padColor);
                    this.padGrid.lightEx(sound, 2, drumPad.isMute() ? 14 : 16);
                    this.padGrid.lightEx(sound, 3, drumPad.isSolo() ? 7 : 9);
                } else {
                    start = 0;
                }
                for (int row = start; row < this.numRows; ++row) {
                    this.padGrid.lightEx(sound, row, black);
                }
            }
            return;
        }
        super.drawGrid();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (((OxiOneControlSurface)this.surface).isMutePressed()) {
            IDrumDevice primary = this.getDrumDevice();
            if (velocity != 0 || !this.isActive() || !primary.hasDrumPads()) {
                return;
            }
            int index = note - this.padGrid.getStartNote();
            int x = index % this.numColumns;
            int y = this.padGrid.getRows() - 1 - index / this.numColumns;
            int sound = x;
            IDrumPadBank drumPadBank = primary.getDrumPadBank();
            IDrumPad drumPad = drumPadBank.getItem(sound);
            if (!drumPad.doesExist()) {
                return;
            }
            switch (y) {
                case 0: {
                    ((ISlot)this.model.getCursorTrack().getSlotBank().getItem(x)).select();
                    break;
                }
                case 1: {
                    drumPad.select();
                    if (((OxiOneControlSurface)this.surface).getModeManager().isActive(new Modes[]{Modes.DEVICE_LAYER})) break;
                    ((OxiOneControlSurface)this.surface).getDisplay().notify(drumPad.getName(12));
                    break;
                }
                case 2: {
                    drumPad.toggleMute();
                    break;
                }
                case 3: {
                    drumPad.toggleSolo();
                    break;
                }
            }
            return;
        }
        boolean init = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_IN);
        boolean end = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.PUNCH_OUT);
        if (init || end) {
            if (velocity == 0) {
                INoteClip clip = this.getClip();
                int lengthOfOnePage = this.getLengthOfOnePage(this.sequencerSteps);
                int offset = clip.getEditPage() * lengthOfOnePage;
                int index = note - this.padGrid.getStartNote();
                int y = this.padGrid.getRows() - index / this.numColumns - 3;
                int x = y * this.numColumns + index % this.numColumns;
                double lengthOfOnePad = Resolution.getValueAt(this.getResolutionIndex());
                double pos = (double)offset + (double)x * lengthOfOnePad;
                double newStart = init ? pos : clip.getLoopStart();
                double newLength = end ? Math.max(pos - newStart + lengthOfOnePad, lengthOfOnePad) : clip.getLoopLength();
                clip.setLoopStart(newStart);
                clip.setLoopLength(newLength);
                clip.setPlayRange(newStart, newStart + newLength);
            }
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    protected int[] getDrumMatrix() {
        return DRUM_MATRIX_LARGE;
    }
}

