/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.controller;

import de.mossgrabers.framework.controller.display.AbstractGraphicDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.graphics.ChromaticGraphicsConfiguration;
import de.mossgrabers.framework.graphics.DefaultGraphicsDimensions;
import de.mossgrabers.framework.graphics.IBitmap;
import java.util.BitSet;

public class OxiOneDisplay
extends AbstractGraphicDisplay {
    private static final int NUM_COLS = 128;
    private static final int NUM_ROWS = 64;
    private static final int NUM_PIXELS = 8192;
    private final IMidiOutput output;
    private final BitSet oledBitmap = new BitSet(8192);
    private final BitSet oldOledBitmap = new BitSet(8192);
    private final byte[] displayData = new byte[2056];
    private long lastSend = System.currentTimeMillis();

    public OxiOneDisplay(IHost host, IMidiOutput output, int maxParameterValue) {
        super(host, new ChromaticGraphicsConfiguration(), new DefaultGraphicsDimensions(128, 64, maxParameterValue), "OXI One Display");
        this.output = output;
        this.displayData[0] = -16;
        this.displayData[1] = 0;
        this.displayData[2] = 33;
        this.displayData[3] = 91;
        this.displayData[4] = 0;
        this.displayData[5] = 1;
        this.displayData[6] = 3;
        this.displayData[this.displayData.length - 1] = -9;
    }

    @Override
    public void notify(String message) {
        if (message == null) {
            return;
        }
        this.host.showNotification(message);
        this.setNotificationMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void send(IBitmap image) {
        byte[] byArray = this.displayData;
        synchronized (this.displayData) {
            image.encode((imageBuffer, width, height) -> {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        byte blue = imageBuffer.get();
                        byte green = imageBuffer.get();
                        byte red = imageBuffer.get();
                        imageBuffer.get();
                        this.oledBitmap.set(y * 128 + x, blue + green + red < 0);
                    }
                }
            });
            long now = System.currentTimeMillis();
            if (this.oledBitmap.equals(this.oldOledBitmap)) {
                if (now - this.lastSend < 3000L) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            } else {
                this.oldOledBitmap.clear();
                this.oldOledBitmap.or(this.oledBitmap);
                int pos = 7;
                for (int y = 0; y < 64; y += 8) {
                    for (int x = 0; x < 128; ++x) {
                        byte nibble1 = 0;
                        byte nibble2 = 0;
                        for (int bit = 0; bit < 8; ++bit) {
                            if (!this.oledBitmap.get((y + bit) * 128 + x)) continue;
                            if (bit > 3) {
                                nibble1 = (byte)(nibble1 | 1 << bit - 4);
                                continue;
                            }
                            nibble2 = (byte)(nibble2 | 1 << bit);
                        }
                        this.displayData[pos] = nibble1;
                        this.displayData[pos + 1] = nibble2;
                        pos += 2;
                    }
                }
            }
            this.lastSend = now;
            this.output.sendSysex(this.displayData);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

