/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;

public class ProjectView
extends AbstractView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    public ProjectView(LaunchpadControlSurface surface, IModel model) {
        super("Project", surface, model);
    }

    @Override
    public void drawGrid() {
        int i;
        IPadGrid padGrid = ((LaunchpadControlSurface)this.surface).getPadGrid();
        padGrid.light(36, 0);
        padGrid.light(37, 9);
        padGrid.light(38, 5);
        padGrid.light(39, 0);
        padGrid.light(40, 29);
        padGrid.light(41, 0);
        padGrid.light(42, 17);
        padGrid.light(43, 0);
        for (i = 44; i < 52; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(52, 0);
        padGrid.light(53, 0);
        padGrid.light(54, 47);
        padGrid.light(55, 0);
        padGrid.light(56, 46);
        padGrid.light(57, 0);
        padGrid.light(58, 45);
        padGrid.light(59, 0);
        for (i = 60; i < 68; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(68, 57);
        for (i = 69; i < 75; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(75, 54);
        for (i = 76; i < 92; ++i) {
            padGrid.light(i, 0);
        }
        padGrid.light(92, 0);
        padGrid.light(93, 41);
        padGrid.light(94, 41);
        boolean isEngineActive = this.model.getApplication().isEngineActive();
        padGrid.light(95, isEngineActive ? 21 : 7);
        padGrid.light(96, isEngineActive ? 21 : 7);
        padGrid.light(97, 41);
        padGrid.light(98, 41);
        padGrid.light(99, 0);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        switch (note) {
            case 37: {
                this.model.getApplication().toggleNoteEditor();
                break;
            }
            case 38: {
                this.model.getApplication().toggleAutomationEditor();
                break;
            }
            case 40: {
                this.model.getApplication().toggleDevices();
                break;
            }
            case 42: {
                this.model.getApplication().toggleMixer();
                break;
            }
            case 54: {
                this.model.getApplication().setPanelLayout("ARRANGE");
                break;
            }
            case 56: {
                this.model.getApplication().setPanelLayout("MIX");
                break;
            }
            case 58: {
                this.model.getApplication().setPanelLayout("EDIT");
                break;
            }
            case 68: {
                this.model.getApplication().toggleInspector();
                break;
            }
            case 75: {
                this.model.getApplication().toggleBrowserVisibility();
                break;
            }
            case 93: 
            case 94: {
                this.model.getProject().previous();
                break;
            }
            case 95: 
            case 96: {
                this.model.getApplication().toggleEngineActive();
                break;
            }
            case 97: 
            case 98: {
                this.model.getProject().next();
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return 0;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        scrollStates.setAll(true);
    }
}

