/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.mini.controller;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.view.Views;

public class LaunchkeyPadGrid
extends PadGridImpl {
    private static final int[] MAP_DRUM = new int[]{36, 37, 38, 39, 44, 45, 46, 47, 40, 41, 42, 43, 48, 49, 50, 51};
    private static final int[] MAP_SESSION = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 96, 97, 98, 99, 100, 101, 102, 103};
    private Views activeView;

    public LaunchkeyPadGrid(ColorManager colorManager, IMidiOutput output) {
        super(colorManager, output, 2, 8, 36);
    }

    @Override
    public int translateToGrid(int note) {
        if (this.activeView == null) {
            return note;
        }
        switch (this.activeView) {
            case SESSION: {
                if (note < 112) {
                    return note - 52;
                }
                return note - 76;
            }
            case DRUM: {
                if (note >= 44 && note < 48) {
                    return note - 4;
                }
                if (note >= 40 && note < 44) {
                    return note + 4;
                }
                return note;
            }
        }
        return note;
    }

    @Override
    public int[] translateToController(int note) {
        return LaunchkeyPadGrid.translateToController(this.activeView, note);
    }

    public static int[] translateToController(Views view, int note) {
        int[] result = new int[2];
        if (view == null || view == Views.SESSION) {
            result[0] = 0;
            result[1] = MAP_SESSION[note - 36];
        } else {
            result[0] = 9;
            result[1] = MAP_DRUM[note - 36];
        }
        return result;
    }

    @Override
    protected void sendNoteState(int channel, int note, int color) {
        if (this.activeView != null && this.activeView == Views.DRUM) {
            this.output.sendNoteEx(9, note, color);
        } else {
            this.output.sendNote(note, color);
        }
    }

    @Override
    protected void sendBlinkState(int channel, int note, int blinkColor, boolean fast) {
        if (this.activeView != null && this.activeView == Views.DRUM) {
            this.output.sendNoteEx(9 + (fast ? 1 : 2), note, blinkColor);
        } else {
            this.output.sendNoteEx(fast ? 1 : 2, note, blinkColor);
        }
    }

    public void setView(Views view) {
        this.activeView = view;
    }
}

