/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.mode;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.TrackType;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.List;
import java.util.Optional;

public class MixerMode
extends TrackVolumeMode<KontrolProtocolControlSurface, KontrolProtocolConfiguration> {
    public MixerMode(KontrolProtocolControlSurface surface, IModel model, List<ContinuousID> controls) {
        super(surface, model, false);
        this.setControls(controls);
        this.setParameterProvider(new CombinedParameterProvider(new VolumeParameterProvider(model), new PanParameterProvider(model)));
    }

    @Override
    public int getKnobValue(int index) {
        ISceneBank sceneBank;
        IValueChanger valueChanger = this.model.getValueChanger();
        if (index >= 80 && index < 88) {
            ITrack track = (ITrack)this.bank.getItem(index - 80);
            return valueChanger.toMidiValue(track.getVolume());
        }
        if (index >= 88 && index < 96) {
            ITrack track = (ITrack)this.bank.getItem(index - 88);
            return valueChanger.toMidiValue(track.getPan());
        }
        Optional selectedTrack = this.bank.getSelectedItem();
        int scrollTracksState = (this.bank.canScrollBackwards() ? 1 : 0) + (this.bank.canScrollForwards() ? 2 : 0);
        int scrollClipsState = 0;
        if (selectedTrack.isPresent()) {
            ISlotBank slotBank = ((ITrack)selectedTrack.get()).getSlotBank();
            scrollClipsState = (slotBank.canScrollBackwards() ? 1 : 0) + (slotBank.canScrollForwards() ? 2 : 0);
        }
        int scrollScenesState = ((sceneBank = this.model.getSceneBank()).canScrollBackwards() ? 1 : 0) + (sceneBank.canScrollForwards() ? 2 : 0);
        KontrolProtocolConfiguration configuration = (KontrolProtocolConfiguration)((KontrolProtocolControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 49: {
                return (this.bank.canScrollPageBackwards() ? 1 : 0) + (this.bank.canScrollPageForwards() ? 2 : 0);
            }
            case 48: {
                if (configuration.isFlipTrackClipNavigation()) {
                    return configuration.isFlipClipSceneNavigation() ? scrollScenesState : scrollClipsState;
                }
                return scrollTracksState;
            }
            case 50: {
                if (configuration.isFlipTrackClipNavigation()) {
                    return scrollTracksState;
                }
                return configuration.isFlipClipSceneNavigation() ? scrollScenesState : scrollClipsState;
            }
        }
        return 0;
    }

    @Override
    public void updateDisplay() {
        ((KontrolProtocolControlSurface)this.surface).sendGlobalValues(this.model);
        IValueChanger valueChanger = this.model.getValueChanger();
        boolean hasSolo = this.model.getProject().hasSolo();
        int protocolVersion = ((KontrolProtocolControlSurface)this.surface).getProtocolVersion();
        int[] vuData = new int[16];
        for (int i = 0; i < 8; ++i) {
            ITrack track = (ITrack)this.bank.getItem(i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(64, TrackType.toTrackType(track.getType()), i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(66, track.isSelected() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(69, track.isRecArm() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(70, 0, i, track.getVolumeStr(8));
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(71, 0, i, track.getPanStr(8));
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(72, 0, i, this.formatTrackName(track));
            if (protocolVersion == 4) {
                ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(75, 0, i, "#" + StringUtils.formatColor(track.getColor()));
            }
            int j = 2 * i;
            vuData[j] = valueChanger.toMidiValue(track.getVuLeft());
            vuData[j + 1] = valueChanger.toMidiValue(track.getVuRight());
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(67, track.isMute() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(68, track.isSolo() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(74, !track.isSolo() && hasSolo ? 1 : 0, i);
            Optional selectedTrack = this.bank.getSelectedItem();
            ((KontrolProtocolControlSurface)this.surface).sendCommand(104, selectedTrack.isPresent() ? TrackType.toTrackType(((ITrack)selectedTrack.get()).getType()) : 0);
            ((KontrolProtocolControlSurface)this.surface).sendCommand(105, selectedTrack.isPresent() && !((ITrack)selectedTrack.get()).isSolo() && hasSolo ? 1 : 0);
        }
        ((KontrolProtocolControlSurface)this.surface).sendKontrolSysEx(73, 2, 0, vuData);
    }

    private String formatTrackName(ITrack track) {
        if (!track.doesExist()) {
            return "";
        }
        String name = track.getName();
        switch (((KontrolProtocolControlSurface)this.surface).getProtocolVersion()) {
            case 1: {
                return name;
            }
            case 2: {
                return "Track " + (track.getPosition() + 1) + "\n" + name;
            }
        }
        return track.getPosition() + 1 + ": " + name;
    }
}

