/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.view;

import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BaseSequencerView;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.scale.Scales;
import java.util.Optional;

public class SequencerView
extends BaseSequencerView {
    private static final int NUM_DISPLAY_COLS = 16;
    private static final int START_KEY = 36;
    protected int offsetY = 36;

    public SequencerView(BeatstepControlSurface surface, IModel model) {
        super("Sequencer", surface, model, 128, 16);
        ITrackBank tb = model.getTrackBank();
        tb.addSelectionObserver((index, isSelected) -> this.keyManager.clearPressedKeys());
        tb.addNoteObserver(this::updateNote);
    }

    @Override
    public void onKnob(int index, int value) {
        boolean isIncrease = this.model.getValueChanger().isIncrease(value);
        switch (index) {
            case 12: {
                this.changeScrollPosition(isIncrease);
                break;
            }
            case 13: {
                this.changeResolution(value);
                ((BeatstepControlSurface)this.surface).getDisplay().notify(Resolution.getNameAt(this.getResolutionIndex()));
                break;
            }
            case 14: {
                this.keyManager.clearPressedKeys();
                if (isIncrease) {
                    this.scales.incOctave();
                } else {
                    this.scales.decOctave();
                }
                this.updateNoteMapping();
                ((BeatstepControlSurface)this.surface).getDisplay().notify(this.scales.getRangeText());
                break;
            }
            case 15: {
                this.isPlayMode = !isIncrease;
                ((BeatstepControlSurface)this.surface).getDisplay().notify(this.isPlayMode ? "Play/Select" : "Sequence");
                this.updateNoteMapping();
                break;
            }
            default: {
                this.extensions.onTrackKnob(index, value);
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        if (this.isPlayMode) {
            this.selectedPad = index;
            for (int i = 0; i < 128; ++i) {
                if (this.keyManager.map(note) != this.keyManager.map(i)) continue;
                this.keyManager.setKeyPressed(i, velocity);
            }
        } else if (velocity != 0) {
            int step = index < 8 ? index + 8 : index - 8;
            int y = this.offsetY + this.selectedPad;
            int map = this.scales.getNoteMatrix()[y];
            NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, map);
            this.getClip().toggleStep(notePosition, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
        }
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() && this.isPlayMode ? this.scales.getNoteMatrix() : Scales.getEmptyMatrix());
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((BeatstepControlSurface)this.surface).getPadGrid();
        if (!this.model.canSelectedTrackHoldNotes()) {
            padGrid.turnOff();
            return;
        }
        if (this.isPlayMode) {
            for (int i = 36; i < 52; ++i) {
                padGrid.light(i, this.keyManager.isKeyPressed(i) || this.selectedPad == i - 36 ? 17 : this.colorManager.getColorIndex(this.keyManager.getColor(i)));
            }
        } else {
            INoteClip clip = this.getClip();
            int step = clip.getCurrentStep();
            int hiStep = this.isInXRange(step) ? step % 16 : -1;
            NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), 0, 0);
            for (int col = 0; col < 16; ++col) {
                notePosition.setStep(col);
                notePosition.setNote(this.scales.getNoteMatrix()[this.offsetY + this.selectedPad]);
                StepState stepState = clip.getStep(notePosition).getState();
                padGrid.lightEx(col % 8, 1 - col / 8, SequencerView.getSequencerColor(stepState, col == hiStep));
            }
        }
    }

    private static int getSequencerColor(StepState stepState, boolean hilite) {
        if (stepState != StepState.OFF) {
            return hilite ? 17 : 16;
        }
        return hilite ? 17 : 0;
    }

    private void updateNote(int trackIndex, int note, int velocity) {
        Optional sel = this.model.getCurrentTrackBank().getSelectedItem();
        if (sel.isEmpty() || ((ITrack)sel.get()).getIndex() != trackIndex) {
            return;
        }
        for (int i = 0; i < 128; ++i) {
            if (this.keyManager.map(i) != note) continue;
            this.keyManager.setKeyPressed(i, velocity);
        }
    }
}

