/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini.view;

import de.mossgrabers.controller.akai.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.akai.apcmini.view.APCminiView;
import de.mossgrabers.controller.akai.apcmini.view.TrackButtons;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;

public class PlayView
extends AbstractPlayView<APCminiControlSurface, APCminiConfiguration>
implements APCminiView {
    private final TrackButtons trackButtons;

    public PlayView(APCminiControlSurface surface, IModel model, TrackButtons trackButtons, boolean useTrackColor) {
        super(surface, model, useTrackColor);
        this.trackButtons = trackButtons;
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        this.trackButtons.onSelectTrack(index, event);
    }

    @Override
    public int getTrackButtonColor(int index) {
        return this.trackButtons.getTrackButtonColor(index);
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        return ButtonID.SCENE3 == buttonID ? "BUTTON_STATE_OFF" : "BUTTON_STATE_ON";
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN || !this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        switch (buttonID) {
            case SCENE1: {
                this.scales.nextScaleLayout();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Scale layout: " + this.scales.getScaleLayout().getName());
                break;
            }
            case SCENE2: {
                this.scales.prevScaleLayout();
                ((APCminiControlSurface)this.surface).getDisplay().notify("Scale layout: " + this.scales.getScaleLayout().getName());
                break;
            }
            case SCENE4: {
                this.scales.prevScale();
                ((APCminiControlSurface)this.surface).getDisplay().notify(this.scales.getScale().getName());
                break;
            }
            case SCENE5: {
                this.scales.nextScale();
                ((APCminiControlSurface)this.surface).getDisplay().notify(this.scales.getScale().getName());
                break;
            }
            case SCENE6: {
                this.scales.toggleChromatic();
                ((APCminiControlSurface)this.surface).getDisplay().notify(this.scales.isChromatic() ? "Chromatic" : "In Key");
                break;
            }
            case SCENE7: {
                this.onOctaveUp(event);
                break;
            }
            case SCENE8: {
                this.onOctaveDown(event);
                break;
            }
        }
        this.updateScale();
    }
}

