/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.argument.OSCTimeTag64;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class OSCBundle
implements OSCPacket {
    private static final long serialVersionUID = 1L;
    private OSCTimeTag64 timestamp;
    private List<OSCPacket> packets;

    public OSCBundle() {
        this(OSCTimeTag64.IMMEDIATE);
    }

    public OSCBundle(OSCTimeTag64 timestamp) {
        this(null, timestamp);
    }

    public OSCBundle(List<OSCPacket> packets) {
        this(packets, OSCTimeTag64.IMMEDIATE);
    }

    public OSCBundle(List<OSCPacket> packets, OSCTimeTag64 timestamp) {
        this.packets = null == packets ? new LinkedList<OSCPacket>() : new ArrayList<OSCPacket>(packets);
        OSCBundle.checkNonNullTimestamp(timestamp);
        this.timestamp = timestamp;
    }

    private static void checkNonNullTimestamp(OSCTimeTag64 timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Bundle time-stamp may not be null; you may want to use OSCTimeStamp.IMMEDIATE.");
        }
    }

    public OSCTimeTag64 getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OSCTimeTag64 timestamp) {
        OSCBundle.checkNonNullTimestamp(timestamp);
        this.timestamp = timestamp;
    }

    public void addPacket(OSCPacket packet) {
        this.packets.add(packet);
    }

    public List<OSCPacket> getPackets() {
        return Collections.unmodifiableList(this.packets);
    }
}

