/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.observer.INoteObserver;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.TreeNode;
import de.mossgrabers.reaper.framework.daw.ApplicationImpl;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.Note;
import de.mossgrabers.reaper.framework.daw.data.DrumPadImpl;
import de.mossgrabers.reaper.framework.daw.data.MasterTrackImpl;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.AbstractTrackBankImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class TrackBankImpl
extends AbstractTrackBankImpl {
    protected static final int NOTE_OFF = 0;
    protected static final int NOTE_ON = 1;
    protected static final int NOTE_ON_NEW = 2;
    private final List<IDrumDevice> drumDevices;
    private final boolean hasFlatTrackList;
    private final boolean hasFullFlatTrackList;
    private boolean skipDisabledItems;
    private final AtomicBoolean isDirty = new AtomicBoolean(false);
    private final Set<INoteObserver> noteObservers = new HashSet<INoteObserver>();
    private final int[] noteCache = new int[128];
    private TrackImpl master;
    private final List<TrackImpl> flatTracks = new ArrayList<TrackImpl>();
    private TreeNode<TrackImpl> rootTrack = new TreeNode();
    private TreeNode<TrackImpl> currentFolder = this.rootTrack;

    public TrackBankImpl(DataSetupEx dataSetup, ApplicationImpl application, int numTracks, ISceneBank sceneBank, int numScenes, int numSends, int numParams, boolean hasFlatTrackList, boolean hasFullFlatTrackList) {
        this(dataSetup, application, Collections.emptyList(), numTracks, sceneBank, numScenes, numSends, numParams, hasFlatTrackList, hasFullFlatTrackList);
    }

    public TrackBankImpl(DataSetupEx dataSetup, ApplicationImpl application, List<IDrumDevice> drumDevices, int numTracks, ISceneBank sceneBank, int numScenes, int numSends, int numParams, boolean hasFlatTrackList, boolean hasFullFlatTrackList) {
        super(dataSetup, application, numTracks, sceneBank, numScenes, numSends, numParams);
        this.drumDevices = drumDevices;
        this.hasFlatTrackList = hasFlatTrackList;
        this.hasFullFlatTrackList = hasFullFlatTrackList;
    }

    @Override
    public void enableObservers(boolean enable) {
        this.sender.enableUpdates(Processor.TRACK, enable);
    }

    public void setMasterTrack(TrackImpl master) {
        this.master = master;
    }

    public void enterCurrentFolder() {
        if (this.hasFlatTrackList) {
            return;
        }
        List<TreeNode<TrackImpl>> tracks = this.currentFolder.getChildren();
        for (TreeNode<TrackImpl> node : tracks) {
            TrackImpl data = node.getData();
            if (!data.isSelected() || !data.isGroup()) continue;
            this.currentFolder = node;
            List<TreeNode<TrackImpl>> children = node.getChildren();
            if (!children.isEmpty()) {
                children.get(0).getData().select();
            }
            this.firePageObserver();
            break;
        }
    }

    @Override
    public void selectParent() {
        if (this.hasFlatTrackList) {
            return;
        }
        TrackImpl previousFolder = this.currentFolder.getData();
        TreeNode<TrackImpl> parent = this.currentFolder.getParent();
        TreeNode<TrackImpl> treeNode = this.currentFolder = parent == null ? this.rootTrack : parent;
        if (previousFolder != null) {
            previousFolder.select();
        }
        this.firePageObserver();
    }

    @Override
    public boolean hasParent() {
        return !this.hasFlatTrackList && this.currentFolder.getParent() != null;
    }

    @Override
    public void scrollTo(int position, boolean adjustPage) {
        TrackImpl trackImpl;
        if (this.hasFlatTrackList && this.hasFullFlatTrackList && (trackImpl = this.flatTracks.get(position)) instanceof MasterTrackImpl) {
            MasterTrackImpl master = (MasterTrackImpl)trackImpl;
            master.select();
            return;
        }
        super.scrollTo(position, adjustPage);
    }

    public void handleBankTrackSelection(ITrack track, boolean isSelected) {
        if (this.hasFlatTrackList) {
            int position;
            if (isSelected && (position = track instanceof IMasterTrack ? (this.hasFullFlatTrackList && this.master != null ? this.flatTracks.size() - 1 : -1) : track.getPosition()) >= 0 && !this.isOnSelectedPage(position)) {
                this.setBankOffset(position / this.pageSize * this.pageSize);
            }
        } else {
            if (track instanceof IMasterTrack) {
                return;
            }
            this.findSelectedTrack(this.rootTrack);
        }
        this.notifySelectionObservers(track.getIndex(), isSelected);
        if (isSelected) {
            for (IDrumDevice drumDevice : this.drumDevices) {
                IDrumPadBank drumPadBank = drumDevice.getDrumPadBank();
                for (int i = 0; i < drumPadBank.getPageSize(); ++i) {
                    ((DrumPadImpl)drumPadBank.getItem(i)).setColorSupplier(track::getColor);
                }
            }
        }
    }

    private boolean findSelectedTrack(TreeNode<TrackImpl> node) {
        List<TreeNode<TrackImpl>> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TreeNode<TrackImpl> child = children.get(i);
            TrackImpl track = child.getData();
            if (track.isSelected()) {
                this.currentFolder = node;
                this.setBankOffset(i / this.pageSize * this.pageSize);
                return true;
            }
            if (!track.isGroup() || !this.findSelectedTrack(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canEditSend(int sendIndex) {
        for (int i = 0; i < this.getPageSize(); ++i) {
            ISend send;
            ISendBank sendBank = this.getItem(i).getSendBank();
            if (sendBank.getItemCount() <= 0 || !(send = (ISend)sendBank.getItem(sendIndex)).doesExist()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getEditSendName(int sendIndex) {
        return this.canEditSend(sendIndex) ? "Send " + (sendIndex + 1) : "";
    }

    @Override
    public boolean isClipRecording() {
        return false;
    }

    @Override
    public ITrack getItem(int index) {
        this.recalcTrackList();
        int id = this.bankOffset + index;
        if (this.hasFlatTrackList) {
            return id >= 0 && id < this.flatTracks.size() ? (ITrack)this.flatTracks.get(id) : (ITrack)this.emptyItem;
        }
        List<TreeNode<TrackImpl>> children = this.currentFolder.getChildren();
        return id < children.size() ? (ITrack)children.get(id).getData() : (ITrack)this.emptyItem;
    }

    @Override
    public int getItemCount() {
        this.recalcTrackList();
        if (this.hasFlatTrackList) {
            return this.flatTracks.size();
        }
        return this.currentFolder.getChildren().size();
    }

    protected boolean isOnSelectedPage(int position) {
        if (this.hasFlatTrackList) {
            return position >= this.bankOffset && position < this.bankOffset + this.pageSize;
        }
        for (int i = 0; i < this.getPageSize(); ++i) {
            if (this.getItem(i).getPosition() != position) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addNoteObserver(INoteObserver observer) {
        this.noteObservers.add(observer);
    }

    protected void notifyNoteObservers(int trackPosition, int note, int velocity) {
        if (!this.isOnSelectedPage(trackPosition)) {
            return;
        }
        int trackIndex = ((TrackImpl)this.getUnpagedItem(trackPosition)).getIndex();
        for (INoteObserver noteObserver : this.noteObservers) {
            noteObserver.call(trackIndex, note, velocity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDirty() {
        AtomicBoolean atomicBoolean = this.isDirty;
        synchronized (atomicBoolean) {
            this.isDirty.set(true);
        }
    }

    @Override
    public void setSkipDisabledItems(boolean shouldSkip) {
        this.skipDisabledItems = shouldSkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotes(int trackPosition, List<Note> notes) {
        int[] nArray = this.noteCache;
        synchronized (this.noteCache) {
            for (Note note : notes) {
                int pitch = note.getPitch();
                this.noteCache[pitch] = 2;
                this.notifyNoteObservers(trackPosition, pitch, note.getVelocity());
            }
            for (int i = 0; i < this.noteCache.length; ++i) {
                if (this.noteCache[i] == 2) {
                    this.noteCache[i] = 1;
                    continue;
                }
                if (this.noteCache[i] != 1) continue;
                this.noteCache[i] = 0;
                this.notifyNoteObservers(trackPosition, i, 0);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setFilterDeactivatedTracks(boolean filterDeactivatedTracks) {
        this.skipDisabledItems = filterDeactivatedTracks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcTrackList() {
        AtomicBoolean atomicBoolean = this.isDirty;
        synchronized (atomicBoolean) {
            if (!this.isDirty.get()) {
                return;
            }
            List list = this.items;
            synchronized (list) {
                if (this.hasFlatTrackList) {
                    this.calcFlatTrack();
                } else {
                    this.calcTreeTracks();
                }
            }
            this.isDirty.set(false);
            this.firePageObserver();
        }
    }

    private void calcTreeTracks() {
        TreeNode newRoot = new TreeNode();
        this.currentFolder = null;
        ArrayList<TreeNode<TrackImpl>> hierarchy = new ArrayList<TreeNode<TrackImpl>>();
        hierarchy.add(newRoot);
        for (int i = 0; i < super.getItemCount(); ++i) {
            this.insertInHierarchy((TrackImpl)this.getUnpagedItem(i), hierarchy);
        }
        this.rootTrack = newRoot;
        if (this.currentFolder == null) {
            this.currentFolder = newRoot;
        }
    }

    private void insertInHierarchy(TrackImpl track, List<TreeNode<TrackImpl>> hierarchy) {
        if (this.skipDisabledItems && !track.isActivated()) {
            return;
        }
        int depth = track.getDepth();
        if (depth >= hierarchy.size()) {
            return;
        }
        TreeNode<TrackImpl> p = hierarchy.get(depth);
        TreeNode<TrackImpl> child = p.addChild(track);
        int childrenSize = p.getChildren().size();
        track.setIndex((childrenSize - 1) % this.pageSize);
        int index = depth + 1;
        if (index < hierarchy.size()) {
            hierarchy.set(index, child);
        } else {
            hierarchy.add(index, child);
        }
        if (track.isSelected()) {
            this.currentFolder = p;
            this.bankOffset = childrenSize / this.pageSize * this.pageSize;
        }
    }

    private void calcFlatTrack() {
        int i;
        this.flatTracks.clear();
        for (i = 0; i < super.getItemCount(); ++i) {
            TrackImpl track = (TrackImpl)this.getUnpagedItem(i);
            if (this.skipDisabledItems && !track.isActivated()) continue;
            this.flatTracks.add(track);
        }
        if (this.hasFullFlatTrackList && this.master != null) {
            this.flatTracks.add(this.master);
        }
        for (i = 0; i < this.flatTracks.size(); ++i) {
            this.flatTracks.get(i).setIndex(i % this.pageSize);
        }
    }

    public boolean hasFullFlatTrackList() {
        return this.hasFullFlatTrackList;
    }
}

