/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;
import java.util.Optional;

public class MuteParameter
extends AbstractParameterImpl {
    private final IModel model;

    public MuteParameter(IModel model) {
        super(model.getValueChanger(), 0);
        this.model = model;
    }

    @Override
    public int getValue() {
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        return selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).isMute() ? this.valueChanger.getUpperBound() - 1 : 0;
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        if (selectedTrack.isPresent()) {
            ((ITrack)selectedTrack.get()).setMute(value > 0);
        }
    }

    @Override
    public void setNormalizedValue(double value) {
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        if (selectedTrack.isPresent()) {
            ((ITrack)selectedTrack.get()).setMute(value > 0.0);
        }
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        if (selectedTrack.isPresent()) {
            ((ITrack)selectedTrack.get()).setMute(valueChanger.isIncrease(value));
        }
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(value);
    }

    @Override
    public void inc(double increment) {
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        if (selectedTrack.isPresent()) {
            ((ITrack)selectedTrack.get()).setMute(increment > 0.0);
        }
    }

    @Override
    public void resetValue() {
        this.setValue(0);
    }

    @Override
    public String getDisplayedValue() {
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        return selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).isMute() ? "Muted" : "-";
    }

    @Override
    public boolean doesExist() {
        return this.model.getTrackBank().getSelectedItem().isPresent();
    }

    @Override
    public String getName() {
        return "Track Mute";
    }

    @Override
    public int getNumberOfSteps() {
        return 2;
    }
}

