/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.featuregroup;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.featuregroup.AbstractMode;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.FrameworkException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public abstract class AbstractParameterMode<S extends IControlSurface<C>, C extends Configuration, B extends IItem>
extends AbstractMode<S, C>
implements IParametersAdjustObserver {
    public static final List<ContinuousID> DEFAULT_KNOB_IDS = Collections.unmodifiableList(ContinuousID.createSequentialList(ContinuousID.KNOB1, 8));
    protected BooleanSupplier isAlternativeFunction;
    protected boolean scrollBank = false;
    protected IParameterProvider defaultParameterProvider;
    protected Map<ButtonID, IParameterProvider> parameterProviders = new EnumMap<ButtonID, IParameterProvider>(ButtonID.class);
    protected IBank<B> bank;
    protected List<ContinuousID> controls;

    protected AbstractParameterMode(String name, S surface, IModel model) {
        this(name, surface, model, true);
    }

    protected AbstractParameterMode(String name, S surface, IModel model, boolean isAbsolute) {
        this(name, surface, model, isAbsolute, (IBank)null);
    }

    protected AbstractParameterMode(String name, S surface, IModel model, boolean isAbsolute, BooleanSupplier isAlternativeFunction) {
        this(name, surface, model, isAbsolute, null, null, isAlternativeFunction);
    }

    protected AbstractParameterMode(String name, S surface, IModel model, boolean isAbsolute, IBank<B> bank) {
        this(name, surface, model, isAbsolute, bank, null, () -> surface.isShiftPressed());
    }

    protected AbstractParameterMode(String name, S surface, IModel model, boolean isAbsolute, IBank<B> bank, List<ContinuousID> controls) {
        this(name, surface, model, isAbsolute, bank, controls, () -> surface.isShiftPressed());
    }

    protected AbstractParameterMode(String name, S surface, IModel model, boolean isAbsolute, IBank<B> bank, List<ContinuousID> controls, BooleanSupplier isAlternativeFunction) {
        super(name, surface, model, isAbsolute);
        this.isAlternativeFunction = isAlternativeFunction;
        this.bank = bank;
        this.setControls(controls);
    }

    protected void setControls(List<ContinuousID> controls) {
        this.controls = controls == null ? Collections.emptyList() : controls;
        this.initTouchedStates(this.controls.size());
    }

    protected void setParameterProvider(IParameterProvider parameterProvider) {
        this.setParameterProvider(null, parameterProvider);
    }

    protected void setParameterProvider(ButtonID buttonID, IParameterProvider parameterProvider) {
        int parameterSize;
        int controlsSize = this.controls.size();
        if (controlsSize != (parameterSize = parameterProvider.size())) {
            throw new FrameworkException("Number of knobs (" + controlsSize + ") must match the number of parameters (" + parameterSize + ")!");
        }
        if (buttonID == null) {
            this.defaultParameterProvider = parameterProvider;
            return;
        }
        IHwButton button = this.surface.getButton(buttonID);
        if (button == null) {
            throw new FrameworkException("Attempt to set parameters for non-existing button " + String.valueOf((Object)buttonID) + "!");
        }
        this.parameterProviders.put(buttonID, parameterProvider);
        button.addEventHandler(ButtonEvent.DOWN, event -> this.bindControls());
        button.addEventHandler(ButtonEvent.UP, event -> this.bindControls());
    }

    @Override
    public void onActivate() {
        super.onActivate();
        if (this.defaultParameterProvider == null) {
            return;
        }
        this.defaultParameterProvider.addParametersObserver(this);
        this.bindControls();
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        if (this.defaultParameterProvider == null) {
            return;
        }
        this.defaultParameterProvider.removeParametersObserver(this);
        this.unbindControls();
    }

    @Override
    public void parametersAdjusted() {
        this.bindControls();
    }

    @Override
    public int getKnobValue(int index) {
        IParameterProvider parameterProvider = this.getParameterProvider();
        if (parameterProvider == null) {
            return -1;
        }
        IParameter param = parameterProvider.get(index);
        return param.doesExist() ? param.getValue() : -1;
    }

    @Override
    public void selectItem(int index) {
        if (this.bank != null) {
            ((IItem)this.bank.getItem(index)).select();
        }
    }

    @Override
    public Optional<String> getSelectedItemName() {
        return Optional.empty();
    }

    @Override
    public void selectPreviousItem() {
        if (this.isAlternativeFunction.getAsBoolean()) {
            this.selectPreviousItemPage();
            return;
        }
        if (this.bank == null) {
            return;
        }
        if (this.scrollBank) {
            this.bank.scrollBackwards();
        } else {
            this.bank.selectPreviousItem();
        }
    }

    @Override
    public void selectNextItem() {
        if (this.isAlternativeFunction.getAsBoolean()) {
            this.selectNextItemPage();
            return;
        }
        if (this.bank == null) {
            return;
        }
        if (this.scrollBank) {
            this.bank.scrollForwards();
        } else {
            this.bank.selectNextItem();
        }
    }

    @Override
    public void selectPreviousItemPage() {
        if (this.bank != null) {
            this.bank.selectPreviousPage();
        }
    }

    @Override
    public void selectNextItemPage() {
        if (this.bank != null) {
            this.bank.selectNextPage();
        }
    }

    @Override
    public void selectItemPage(int page) {
        if (this.bank == null) {
            return;
        }
        int position = page * this.bank.getPageSize();
        this.bank.scrollTo(position);
    }

    @Override
    public boolean hasPreviousItem() {
        return this.bank != null && this.bank.canScrollBackwards();
    }

    @Override
    public boolean hasNextItem() {
        return this.bank != null && this.bank.canScrollForwards();
    }

    @Override
    public boolean hasPreviousItemPage() {
        return this.bank != null && this.bank.canScrollPageBackwards();
    }

    @Override
    public boolean hasNextItemPage() {
        return this.bank != null && this.bank.canScrollPageForwards();
    }

    @Override
    public String formatPageRange(String format) {
        if (this.bank == null) {
            return "";
        }
        int positionFirst = this.bank.getScrollPosition();
        if (positionFirst < 0) {
            return "";
        }
        int positionLast = this.bank.getPositionOfLastItem();
        return String.format(format, positionFirst + 1, positionLast + 1);
    }

    protected void switchBanks(IBank<B> bank) {
        this.bank = bank;
    }

    protected void bindControls() {
        if (!this.isActive || this.defaultParameterProvider == null) {
            return;
        }
        IParameterProvider parameterProvider = this.getParameterProvider();
        for (int i = 0; i < this.controls.size(); ++i) {
            IParameter parameter = parameterProvider.get(i);
            this.surface.getContinuous(this.controls.get(i)).bind(parameter);
        }
    }

    @Override
    public IParameterProvider getParameterProvider() {
        for (Map.Entry<ButtonID, IParameterProvider> entry : this.parameterProviders.entrySet()) {
            if (!this.surface.isPressed(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.defaultParameterProvider;
    }

    public IBank<B> getBank() {
        return this.bank;
    }

    private void unbindControls() {
        if (this.defaultParameterProvider == null) {
            return;
        }
        for (ContinuousID controlID : this.controls) {
            this.surface.getContinuous(controlID).bind((IParameter)null);
        }
    }
}

