/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.view;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ViewMultiSelectCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected final List<Views> viewIds = new ArrayList<Views>();
    private final boolean displayName;
    private final ButtonEvent triggerEvent;
    private boolean storePreferred;

    public ViewMultiSelectCommand(IModel model, S surface, Views ... viewIds) {
        this(model, surface, true, ButtonEvent.DOWN, viewIds);
    }

    public ViewMultiSelectCommand(IModel model, S surface, boolean storePreferred, Views ... viewIds) {
        this(model, surface, true, ButtonEvent.DOWN, storePreferred, viewIds);
    }

    public ViewMultiSelectCommand(IModel model, S surface, boolean displayName, ButtonEvent triggerEvent, Views ... viewIds) {
        this(model, surface, displayName, triggerEvent, false, viewIds);
    }

    public ViewMultiSelectCommand(IModel model, S surface, boolean displayName, ButtonEvent triggerEvent, boolean storePreferred, Views ... viewIds) {
        super(model, surface);
        this.displayName = displayName;
        this.triggerEvent = triggerEvent;
        this.storePreferred = storePreferred;
        this.viewIds.addAll(Arrays.asList(viewIds));
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        Views viewId;
        if (event != this.triggerEvent) {
            return;
        }
        ViewManager viewManager = this.surface.getViewManager();
        Views activeViewId = (Views)((Object)viewManager.getActiveID());
        int index = this.viewIds.indexOf((Object)activeViewId) + 1;
        if (index < 0 || index >= this.viewIds.size()) {
            index = 0;
        }
        if (viewManager.isActive(new Views[]{viewId = this.viewIds.get(index)})) {
            return;
        }
        if (this.storePreferred) {
            this.activatePreferredView(viewId);
        } else {
            viewManager.setActive(viewId);
        }
        if (this.displayName) {
            this.surface.getDisplay().notify(((IView)viewManager.get(viewId)).getName());
        }
    }
}

