/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.IOxiModeDisplay;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleChannelsComponent;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.mode.track.TrackMode;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;
import de.mossgrabers.framework.parameterprovider.track.SelectedTrackParameterProvider;
import java.util.List;
import java.util.Optional;

public class OxiOneTrackMode
extends TrackMode<OxiOneControlSurface, OxiOneConfiguration>
implements IOxiModeDisplay {
    private static final String[] MENU = new String[]{"Vol", "Pan", "S1", "S2"};
    private static final String[] SHIFTED_MENU = new String[]{"S3", "S4", "S5", "S6"};
    private int selectedIndex = 0;
    private boolean isMixerMode = false;

    public OxiOneTrackMode(OxiOneControlSurface surface, IModel model) {
        super("Track", surface, model, false, (List<ContinuousID>)null);
        this.isAlternativeFunction = () -> false;
        this.scrollBank = true;
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.setParameterProvider(new FourKnobProvider(surface, new SelectedTrackParameterProvider(model), ButtonID.SHIFT));
    }

    @Override
    public void toggleDisplay() {
        this.isMixerMode = !this.isMixerMode;
    }

    @Override
    public void updateDisplay() {
        this.updateMode();
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        display.addElement(this.isMixerMode ? this.drawMixerMode() : this.drawTrackMode());
        display.send();
    }

    private IComponent drawTrackMode() {
        Object desc = "Select";
        Object label = "a track";
        int value = -1;
        int vuLeft = -1;
        int vuRight = -1;
        boolean isPan = false;
        Optional trackOptional = this.model.getCurrentTrackBank().getSelectedItem();
        if (trackOptional.isPresent()) {
            ITrack track = (ITrack)trackOptional.get();
            vuLeft = track.getVuLeft();
            vuRight = track.getVuRight();
            desc = track.getPosition() + 1 + ": " + track.getName(9);
            ISendBank sendBank = track.getSendBank();
            switch (this.selectedIndex) {
                case 0: {
                    label = "Vol: " + track.getVolumeStr();
                    value = track.getVolume();
                    break;
                }
                case 1: {
                    label = "Pan: " + track.getPanStr();
                    value = track.getPan();
                    isPan = true;
                    break;
                }
                default: {
                    int sendIndex = this.selectedIndex - 2;
                    label = OxiOneTrackMode.getSendLabel(sendBank, sendIndex);
                    value = OxiOneTrackMode.getSendValue(sendBank, sendIndex);
                }
            }
        }
        return new TitleValueMenuComponent((String)desc, (String)label, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, vuLeft, vuRight, isPan);
    }

    private IComponent drawMixerMode() {
        boolean isMode;
        int[] values;
        boolean[] selected;
        Object label;
        block10: {
            int size;
            ITrackBank trackBank;
            block9: {
                trackBank = this.model.getCurrentTrackBank();
                Optional trackOptional = trackBank.getSelectedItem();
                label = "None";
                if (trackOptional.isPresent()) {
                    ITrack track = (ITrack)trackOptional.get();
                    label = track.getPosition() + 1 + ": " + track.getName(9);
                }
                size = trackBank.getPageSize();
                selected = new boolean[size];
                values = new int[size];
                boolean bl = isMode = this.isAnyKnobTouched() || !this.model.getTransport().isPlaying();
                if (!isMode) break block9;
                switch (this.selectedIndex) {
                    case 0: {
                        for (int i = 0; i < size; ++i) {
                            IChannel channel = (IChannel)trackBank.getItem(i);
                            selected[i] = channel.isSelected();
                            values[i] = channel.getVolume();
                        }
                        break block10;
                    }
                    case 1: {
                        for (int i = 0; i < size; ++i) {
                            IChannel channel = (IChannel)trackBank.getItem(i);
                            selected[i] = channel.isSelected();
                            values[i] = channel.getPan();
                        }
                        break block10;
                    }
                    default: {
                        int sendIndex = this.selectedIndex - 2;
                        for (int i = 0; i < size; ++i) {
                            ISend send;
                            IChannel channel = (IChannel)trackBank.getItem(i);
                            selected[i] = channel.isSelected();
                            ISendBank sendBank = channel.getSendBank();
                            if (sendBank == null || !(send = (ISend)sendBank.getItem(sendIndex)).doesExist()) continue;
                            values[i] = send.getValue();
                        }
                        break block10;
                    }
                }
            }
            for (int i = 0; i < size; ++i) {
                IChannel channel = (IChannel)trackBank.getItem(i);
                selected[i] = channel.isSelected();
                values[i] = channel.getVu();
            }
        }
        return new TitleChannelsComponent((String)label, selected, values, this.selectedIndex == 1 && isMode);
    }

    protected void updateMode() {
        if (((OxiOneControlSurface)this.surface).isShiftPressed()) {
            if (this.selectedIndex < 4) {
                this.selectedIndex += 4;
            }
        } else if (this.selectedIndex >= 4) {
            this.selectedIndex -= 4;
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedIndex = ((OxiOneControlSurface)this.surface).isShiftPressed() ? 4 + index : index;
        this.setTouchedKnob(index, isTouched);
        Optional trackOptional = this.model.getCurrentTrackBank().getSelectedItem();
        if (!trackOptional.isPresent()) {
            return;
        }
        ITrack track = (ITrack)trackOptional.get();
        switch (this.selectedIndex) {
            case 0: {
                if (isTouched && ((OxiOneControlSurface)this.surface).isDeletePressed()) {
                    track.resetVolume();
                }
                track.touchVolume(isTouched);
                break;
            }
            case 1: {
                if (isTouched && ((OxiOneControlSurface)this.surface).isDeletePressed()) {
                    track.resetPan();
                }
                track.touchPan(isTouched);
                break;
            }
            default: {
                int sendIndex = this.selectedIndex - 2;
                ISend item = (ISend)track.getSendBank().getItem(sendIndex);
                if (isTouched && ((OxiOneControlSurface)this.surface).isDeletePressed()) {
                    item.resetValue();
                }
                item.touchValue(isTouched);
            }
        }
    }

    private static String getSendLabel(ISendBank sendBank, int index) {
        int pos = index + 1;
        if (sendBank == null) {
            return "No FX " + pos;
        }
        ISend send = (ISend)sendBank.getItem(index);
        if (!send.doesExist()) {
            return "No FX " + pos;
        }
        return send.getName(4) + ": " + send.getDisplayedValue();
    }

    private static int getSendValue(ISendBank sendBank, int index) {
        if (sendBank == null) {
            return 0;
        }
        ISend send = (ISend)sendBank.getItem(index);
        return send.doesExist() ? send.getValue() : 0;
    }
}

