/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.controller;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorIndexException;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColor;

public class OxiOneColorManager
extends ColorManager {
    private static final int DAW_COLOR_START = 100;
    private static final int SCALE_COLOR_OCTAVE = 50;
    private static final int SCALE_COLOR_NOTE = 51;
    private static final int SCALE_COLOR_OUT_OF_SCALE = 52;
    public static final int OXI_ONE_COLOR_BLACK = 0;
    public static final int OXI_ONE_COLOR_WHITE = 1;
    public static final int OXI_ONE_COLOR_GREEN = 2;
    public static final int OXI_ONE_COLOR_DARK_GREEN = 3;
    public static final int OXI_ONE_COLOR_RED = 4;
    public static final int OXI_ONE_COLOR_DARK_RED = 5;
    public static final int OXI_ONE_COLOR_DARKER_RED = 6;
    public static final int OXI_ONE_COLOR_BLUE = 7;
    public static final int OXI_ONE_COLOR_DARK_BLUE = 8;
    public static final int OXI_ONE_COLOR_DARKER_BLUE = 9;
    public static final int OXI_ONE_COLOR_DARK_OCEAN = 10;
    public static final int OXI_ONE_COLOR_ORANGE = 11;
    public static final int OXI_ONE_COLOR_DARK_ORANGE = 12;
    public static final int OXI_ONE_COLOR_DARKER_ORANGE = 13;
    public static final int OXI_ONE_COLOR_YELLOW = 14;
    public static final int OXI_ONE_COLOR_DARK_YELLOW = 15;
    public static final int OXI_ONE_COLOR_DARKER_YELLOW = 16;
    public static final int OXI_ONE_COLOR_BROWN = 17;
    public static final int OXI_ONE_COLOR_GRAY = 18;

    public OxiOneColorManager() {
        this.registerColorIndex("SCALE_COLOR_OFF", 0);
        this.registerColorIndex("SCALE_COLOR_OCTAVE", 50);
        this.registerColorIndex("SCALE_COLOR_NOTE", 51);
        this.registerColorIndex("SCALE_COLOR_OUT_OF_SCALE", 52);
        this.registerColorIndex("GRID_COLOR_OFF", 0);
        this.registerColorIndex("COLOR_STEP_HILITE_NO_CONTENT", 3);
        this.registerColorIndex("COLOR_STEP_HILITE_CONTENT", 2);
        this.registerColorIndex("COLOR_STEP_MUTED", 18);
        this.registerColorIndex("COLOR_STEP_MUTED_CONT", 18);
        this.registerColorIndex("COLOR_STEP_SELECTED", 16);
        this.registerColorIndex("COLOR_NO_CONTENT", 0);
        this.registerColorIndex("COLOR_NO_CONTENT_4", 18);
        this.registerColorIndex("COLOR_CONTENT", 7);
        this.registerColorIndex("COLOR_CONTENT_CONT", 8);
        this.registerColorIndex("COLOR_PAGE", 18);
        this.registerColorIndex("COLOR_ACTIVE_PAGE", 4);
        this.registerColorIndex("COLOR_SELECTED_PAGE", 6);
        this.registerColorIndex("COLOR_RESOLUTION", 12);
        this.registerColorIndex("COLOR_RESOLUTION_SELECTED", 11);
        this.registerColorIndex("COLOR_RESOLUTION_OFF", 0);
        this.registerColorIndex("COLOR_TRANSPOSE", 1);
        this.registerColorIndex("COLOR_TRANSPOSE_SELECTED", 14);
        this.registerColorIndex("COLOR_PAD_OFF", 0);
        this.registerColorIndex("COLOR_PAD_RECORD", 4);
        this.registerColorIndex("COLOR_PAD_PLAY", 2);
        this.registerColorIndex("COLOR_PAD_SELECTED", 7);
        this.registerColorIndex("COLOR_PAD_MUTED", 17);
        this.registerColorIndex("COLOR_PAD_HAS_CONTENT", 14);
        this.registerColorIndex("COLOR_PAD_NO_CONTENT", 15);
        this.registerColorIndex("PLAY_VIEW_COLOR_OFF", 0);
        this.registerColorIndex("PLAY_VIEW_COLOR_PLAY", 2);
        this.registerColorIndex("PLAY_VIEW_COLOR_RECORD", 4);
        this.registerColorIndex("COLOR_SCENE", 3);
        this.registerColorIndex("COLOR_SELECTED_SCENE", 2);
        this.registerColorIndex("COLOR_SELECTED_OFF", 0);
        this.registerColorIndex("BUTTON_COLOR_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_ON", 0);
        this.registerColorIndex("BUTTON_STATE_HI", 1);
        this.registerColor(0, ColorEx.BLACK);
        this.registerColor(1, ColorEx.WHITE);
        this.registerColor(2, ColorEx.GREEN);
        this.registerColor(3, ColorEx.DARK_GREEN);
        this.registerColor(4, ColorEx.RED);
        this.registerColor(5, ColorEx.DARK_RED);
        this.registerColor(6, ColorEx.DARKER_RED);
        this.registerColor(7, ColorEx.BLUE);
        this.registerColor(8, ColorEx.DARK_BLUE);
        this.registerColor(9, ColorEx.DARKER_BLUE);
        this.registerColor(10, ColorEx.SKY_BLUE);
        this.registerColor(11, ColorEx.ORANGE);
        this.registerColor(12, ColorEx.DARK_ORANGE);
        this.registerColor(13, ColorEx.DARKER_ORANGE);
        this.registerColor(14, ColorEx.YELLOW);
        this.registerColor(15, ColorEx.DARK_YELLOW);
        this.registerColor(16, ColorEx.DARKER_YELLOW);
        this.registerColor(17, ColorEx.BROWN);
        this.registerColor(18, ColorEx.DARKER_GRAY);
        this.registerColor(50, ColorEx.BLUE);
        this.registerColor(51, ColorEx.WHITE);
        this.registerColor(52, ColorEx.DARK_GRAY);
        DAWColor[] values = DAWColor.values();
        for (int i = 0; i < values.length; ++i) {
            this.registerColorIndex(values[i], 100 + i);
        }
    }

    @Override
    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        if (ButtonID.isInRange(buttonID, ButtonID.PAD1, 128)) {
            if (colorIndex >= 100) {
                return DAWColor.getColorEntry(colorIndex - 100);
            }
            try {
                return super.getColor(colorIndex, buttonID);
            }
            catch (ColorIndexException ex) {
                return ColorEx.RED;
            }
        }
        if (colorIndex == this.getColorIndex("BUTTON_STATE_OFF")) {
            return ColorEx.BLACK;
        }
        if (colorIndex == this.getColorIndex("BUTTON_STATE_ON")) {
            return ColorEx.DARK_GRAY;
        }
        return ColorEx.LIGHT_GRAY;
    }
}

