/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode.device;

import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.device.AbstractParametersMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class SLMkIIITrackParamsMode
extends AbstractParametersMode<IParameter> {
    public SLMkIIITrackParamsMode(SLMkIIIControlSurface surface, IModel model) {
        super("Track Parameters", surface, model, model.getCursorTrack().getParameterBank());
        this.setParameterProvider(new BankParameterProvider(model.getCursorTrack().getParameterBank()));
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_UP)) {
            this.onButtonArrowUp(index);
            return;
        }
        IParameterPageBank parameterPageBank = ((IParameterBank)this.bank).getPageBank();
        parameterPageBank.selectPage(index);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        IParameterPageBank parameterPageBank;
        int selectedPage;
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_UP)) {
            return this.getButtonColorArrowUp(buttonID);
        }
        int index = this.isButtonRow(0, buttonID);
        return index == (selectedPage = (parameterPageBank = ((IParameterBank)this.bank).getPageBank()).getSelectedItemIndex()) ? 9 : 11;
    }

    @Override
    public void updateDisplay() {
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 8, "Track FX").setCell(1, 8, this.model.getCursorTrack().getName(8));
        for (int i = 0; i < this.bank.getPageSize(); ++i) {
            IParameter param = (IParameter)this.bank.getItem(i);
            d.setCell(0, i, param.doesExist() ? StringUtils.fixASCII(param.getName(9)) : "").setCell(1, i, StringUtils.fixASCII(param.getDisplayedValue(9)));
            int color = param.doesExist() ? 9 : 0;
            d.setPropertyColor(i, 0, color);
            d.setPropertyColor(i, 1, color);
        }
        this.drawRow4(d);
        this.setButtonInfo(d);
        d.allDone();
    }

    private void drawRow4(SLMkIIIDisplay d) {
        if (((SLMkIIIControlSurface)this.surface).isLongPressed(ButtonID.ARROW_UP)) {
            this.drawRow4ArrowUp(d);
            return;
        }
        IParameterPageBank parameterPageBank = ((IParameterBank)this.bank).getPageBank();
        int selectedPage = parameterPageBank.getSelectedItemIndex();
        for (int i = 0; i < this.bank.getPageSize(); ++i) {
            String pageName = StringUtils.limit((String)parameterPageBank.getItem(i), 9);
            d.setCell(3, i, pageName);
            d.setPropertyColor(i, 2, pageName.isBlank() ? 0 : 9);
            d.setPropertyValue(i, 1, selectedPage == i ? 1 : 0);
        }
    }

    @Override
    public int getModeColor() {
        return 9;
    }
}

