/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.controller;

import de.mossgrabers.controller.novation.slmkiii.SLMkIIIConfiguration;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIILightGuide;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIPadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.DeviceInquiry;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;

public class SLMkIIIControlSurface
extends AbstractControlSurface<SLMkIIIConfiguration> {
    public static final int MKIII_KNOB_1 = 21;
    public static final int MKIII_KNOB_2 = 22;
    public static final int MKIII_KNOB_3 = 23;
    public static final int MKIII_KNOB_4 = 24;
    public static final int MKIII_KNOB_5 = 25;
    public static final int MKIII_KNOB_6 = 26;
    public static final int MKIII_KNOB_7 = 27;
    public static final int MKIII_KNOB_8 = 28;
    public static final int MKIII_FADER_1 = 41;
    public static final int MKIII_FADER_2 = 42;
    public static final int MKIII_FADER_3 = 43;
    public static final int MKIII_FADER_4 = 44;
    public static final int MKIII_FADER_5 = 45;
    public static final int MKIII_FADER_6 = 46;
    public static final int MKIII_FADER_7 = 47;
    public static final int MKIII_FADER_8 = 48;
    public static final int MKIII_DISPLAY_BUTTON_1 = 51;
    public static final int MKIII_DISPLAY_BUTTON_2 = 52;
    public static final int MKIII_DISPLAY_BUTTON_3 = 53;
    public static final int MKIII_DISPLAY_BUTTON_4 = 54;
    public static final int MKIII_DISPLAY_BUTTON_5 = 55;
    public static final int MKIII_DISPLAY_BUTTON_6 = 56;
    public static final int MKIII_DISPLAY_BUTTON_7 = 57;
    public static final int MKIII_DISPLAY_BUTTON_8 = 58;
    public static final int MKIII_BUTTON_ROW1_1 = 59;
    public static final int MKIII_BUTTON_ROW1_2 = 60;
    public static final int MKIII_BUTTON_ROW1_3 = 61;
    public static final int MKIII_BUTTON_ROW1_4 = 62;
    public static final int MKIII_BUTTON_ROW1_5 = 63;
    public static final int MKIII_BUTTON_ROW1_6 = 64;
    public static final int MKIII_BUTTON_ROW1_7 = 65;
    public static final int MKIII_BUTTON_ROW1_8 = 66;
    public static final int MKIII_BUTTON_ROW2_1 = 67;
    public static final int MKIII_BUTTON_ROW2_2 = 68;
    public static final int MKIII_BUTTON_ROW2_3 = 69;
    public static final int MKIII_BUTTON_ROW2_4 = 70;
    public static final int MKIII_BUTTON_ROW2_5 = 71;
    public static final int MKIII_BUTTON_ROW2_6 = 72;
    public static final int MKIII_BUTTON_ROW2_7 = 73;
    public static final int MKIII_BUTTON_ROW2_8 = 74;
    public static final int MKIII_DISPLAY_UP = 81;
    public static final int MKIII_DISPLAY_DOWN = 82;
    public static final int MKIII_SCENE_1 = 83;
    public static final int MKIII_SCENE_2 = 84;
    public static final int MKIII_SCENE_UP = 85;
    public static final int MKIII_SCENE_DOWN = 86;
    public static final int MKIII_BUTTONS_UP = 87;
    public static final int MKIII_BUTTONS_DOWN = 88;
    public static final int MKIII_GRID = 89;
    public static final int MKIII_OPTIONS = 90;
    public static final int MKIII_SHIFT = 91;
    public static final int MKIII_DUPLICATE = 92;
    public static final int MKIII_CLEAR = 93;
    public static final int MKIII_TRACK_LEFT = 102;
    public static final int MKIII_TRACK_RIGHT = 103;
    public static final int MKIII_TRANSPORT_REWIND = 112;
    public static final int MKIII_TRANSPORT_FORWARD = 113;
    public static final int MKIII_TRANSPORT_STOP = 114;
    public static final int MKIII_TRANSPORT_PLAY = 115;
    public static final int MKIII_TRANSPORT_LOOP = 116;
    public static final int MKIII_TRANSPORT_RECORD = 117;
    public static final int MKIII_FADER_LED_1 = 54;
    public static final int MKIII_BUTTON_STATE_OFF = 0;
    public static final int MKIII_BUTTON_STATE_ON = 1;
    private boolean isMuteSolo = true;

    public SLMkIIIControlSurface(IHost host, ColorManager colorManager, SLMkIIIConfiguration configuration, IMidiOutput output, IMidiInput input, SLMkIIILightGuide lightGuide) {
        super(0, host, configuration, colorManager, output, input, new SLMkIIIPadGrid(colorManager, output), lightGuide, 1000.0, 360.0);
        this.defaultMidiChannel = 15;
        this.addTextDisplay(new SLMkIIIDisplay(host, output));
        this.input.setSysexCallback(this::handleSysEx);
        ((SLMkIIILightGuide)this.lightGuide).setActive(true);
    }

    private void handleSysEx(String data) {
        int[] byteData = StringUtils.fromHexStr(data);
        DeviceInquiry deviceInquiry = new DeviceInquiry(byteData);
        if (deviceInquiry.isValid()) {
            this.handleDeviceInquiryResponse(deviceInquiry);
        }
    }

    private void handleDeviceInquiryResponse(DeviceInquiry deviceInquiry) {
        int[] revisionLevel = deviceInquiry.getRevisionLevel();
        if (revisionLevel.length == 4) {
            String firmwareVersion = String.format("%d%d%d%d", revisionLevel[0], revisionLevel[1], revisionLevel[2], revisionLevel[3]);
            this.host.println("Firmware version: " + (firmwareVersion.charAt(0) == '0' ? firmwareVersion.substring(1) : firmwareVersion));
        }
    }

    @Override
    protected void internalShutdown() {
        super.internalShutdown();
        SLMkIIIDisplay d = this.getDisplay();
        for (int i = 0; i < 8; ++i) {
            d.setFaderLEDColor(54 + i, ColorEx.BLACK);
        }
    }

    @Override
    public SLMkIIIDisplay getDisplay() {
        return (SLMkIIIDisplay)super.getDisplay();
    }

    public boolean isMuteSolo() {
        return this.isMuteSolo;
    }

    public void toggleMuteSolo() {
        this.isMuteSolo = !this.isMuteSolo;
    }
}

