/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.mini;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class LaunchkeyMiniMk3ControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("5359D5B1-28CD-4457-B49D-F8D3D7BC52B9");

    public LaunchkeyMiniMk3ControllerDefinition() {
        super(EXTENSION_ID, "Launchkey Mini Mk3", "Novation", 2, 1);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            default: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"MIDIIN2 (Launchkey Mini MK3)", "Launchkey Mini MK3"}, new String[]{"MIDIOUT2 (Launchkey Mini MK3)"}));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"MIDIIN2 (Launchkey Mini MK3 MID", "Launchkey Mini MK3 MIDI"}, new String[]{"MIDIOUT2 (Launchkey Mini MK3 MI"}));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"Launchkey Mini MK3 DAW Port", "Launchkey Mini MK3 MIDI Port"}, new String[]{"Launchkey Mini MK3 DAW Port"}));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"MK3 [hw:1,0,1]", "MK3 [hw:1,0,0]"}, new String[]{"MK3 [hw:1,0,1]"}));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"MK3 [hw:2,0,1]", "MK3 [hw:2,0,0]"}, new String[]{"MK3 [hw:2,0,1]"}));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"Launchkey Mini MK3 MIDI 2", "Launchkey Mini MK3 MIDI 1"}, new String[]{"Launchkey Mini MK3 MIDI 2"}));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(new String[]{"Launchkey Mini MK3 Launchkey Mi #2", "Launchkey Mini MK3 Launchkey Mi"}, new String[]{"Launchkey Mini MK3 Launchkey Mi #2"}));
            }
        }
        return midiDiscoveryPairs;
    }
}

