/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.IXLMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTemporaryButtonMode;
import de.mossgrabers.framework.command.TempoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.FrameworkException;
import java.util.List;

public abstract class XLAbstractMainMode<B extends IItem>
extends AbstractParameterMode<LaunchControlXLControlSurface, LaunchControlXLConfiguration, B>
implements IXLMode {
    protected final LaunchControlXLConfiguration configuration;
    protected Modes defaultMode = Modes.MUTE;
    protected Modes trackMode;
    private IParameterProvider parameterProvider;
    private IParameterProvider parameterProviderWithDeviceParams;
    private boolean wasLong = false;
    private boolean transportUsed = false;
    private final NewCommand<LaunchControlXLControlSurface, LaunchControlXLConfiguration> newCommand;
    private final TempoCommand<LaunchControlXLControlSurface, LaunchControlXLConfiguration> tempoDown;
    private final TempoCommand<LaunchControlXLControlSurface, LaunchControlXLConfiguration> tempoUp;

    protected XLAbstractMainMode(String name, LaunchControlXLControlSurface surface, IModel model, IBank<B> bank, List<ContinuousID> controls) {
        super(name, surface, model, true, bank, controls);
        this.configuration = (LaunchControlXLConfiguration)((LaunchControlXLControlSurface)this.surface).getConfiguration();
        this.newCommand = new NewCommand(model, surface);
        this.tempoDown = new TempoCommand(false, model, surface);
        this.tempoUp = new TempoCommand(true, model, surface);
    }

    protected void setParameterProviders(IParameterProvider parameterProvider, IParameterProvider parameterProviderWithDeviceParams) {
        this.parameterProvider = parameterProvider;
        this.parameterProviderWithDeviceParams = parameterProviderWithDeviceParams;
        this.setParameterProvider(this.configuration.isDeviceActive() ? this.parameterProviderWithDeviceParams : this.parameterProvider);
    }

    public void toggleDeviceActive() {
        this.configuration.toggleDeviceActive();
        this.setParameterProvider(this.configuration.isDeviceActive() ? this.parameterProviderWithDeviceParams : this.parameterProvider);
        this.bindControls();
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row == 0) {
            this.handleRow0(index, event);
        } else if (row == 2) {
            this.handleRow2(index, event);
        }
    }

    protected void handleRow0(int index, ButtonEvent event) {
        ModeManager modeManager = ((LaunchControlXLControlSurface)this.surface).getFaderModeManager();
        switch (event) {
            case DOWN: {
                if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.REC_ARM)) {
                    this.transportUsed = true;
                    this.handleTransport(index, event);
                    return;
                }
                this.transportUsed = false;
                this.wasLong = false;
                modeManager.setTemporary(Modes.MASTER);
                break;
            }
            case LONG: {
                this.wasLong = true;
                break;
            }
            case UP: {
                if (this.transportUsed) {
                    this.handleTransport(index, event);
                    return;
                }
                modeManager.restore();
                if (this.wasLong) break;
                this.executeRow0(index);
            }
        }
    }

    protected abstract void executeRow0(int var1);

    protected abstract void handleRow2(int var1, ButtonEvent var2);

    protected void alternativeModeSelect(ButtonEvent event, Modes modeID, Modes altModeID) {
        ModeManager trackModeManager = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager();
        if (event == ButtonEvent.DOWN) {
            trackModeManager.setTemporary(altModeID);
            return;
        }
        if (event == ButtonEvent.UP) {
            trackModeManager.restore();
            if (((XLTemporaryButtonMode)trackModeManager.get(altModeID)).hasBeenUsed()) {
                return;
            }
            if (modeID != null) {
                trackModeManager.setActive(modeID);
            }
        }
    }

    @Override
    public void onActivate() {
        if (this.parameterProviderWithDeviceParams == null || this.parameterProvider == null) {
            throw new FrameworkException("Parameter providers must be initialized for XLAbstractMainMode! Call setParameterProviders.");
        }
        this.setParameterProvider(this.configuration.isDeviceActive() ? this.parameterProviderWithDeviceParams : this.parameterProvider);
        ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().setActive(this.trackMode == null ? this.defaultMode : this.trackMode);
        super.onActivate();
    }

    @Override
    public void onDeactivate() {
        this.trackMode = (Modes)((Object)((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActiveID());
        super.onDeactivate();
    }

    private void handleTransport(int index, ButtonEvent event) {
        ITransport transport = this.model.getTransport();
        switch (index) {
            case 0: {
                if (event != ButtonEvent.DOWN) break;
                this.newCommand.handleExecute(false);
                break;
            }
            case 1: {
                if (event != ButtonEvent.DOWN) break;
                transport.toggleLauncherOverdub();
                break;
            }
            case 2: {
                this.tempoDown.execute(event, event == ButtonEvent.DOWN ? 127 : 0);
                break;
            }
            case 3: {
                this.tempoUp.execute(event, event == ButtonEvent.DOWN ? 127 : 0);
                break;
            }
            case 4: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getApplication().undo();
                break;
            }
            case 5: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getApplication().redo();
                break;
            }
            case 6: {
                if (event != ButtonEvent.DOWN) break;
                transport.toggleWriteClipLauncherAutomation();
                break;
            }
            case 7: {
                if (event != ButtonEvent.DOWN) break;
                this.model.getCursorDevice().toggleWindowOpen();
                break;
            }
        }
    }

    protected int getTransportButtonColor(int index) {
        ITransport transport = this.model.getTransport();
        switch (index) {
            case 0: {
                return 29;
            }
            case 1: {
                return transport.isLauncherOverdub() ? 63 : 30;
            }
            case 2: 
            case 3: {
                return 28;
            }
            case 4: {
                return this.model.getApplication().canUndo() ? 29 : 12;
            }
            case 5: {
                return this.model.getApplication().canRedo() ? 29 : 12;
            }
            case 6: {
                return transport.isWritingClipLauncherAutomation() ? 15 : 13;
            }
            case 7: {
                return this.model.getCursorDevice().isWindowOpen() ? 60 : 28;
            }
        }
        return 12;
    }
}

