/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.BaseMode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;

public class PositionMode
extends BaseMode {
    public PositionMode(MaschineControlSurface surface, IModel model) {
        super("Position", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        double speed = this.model.getValueChanger().calcKnobChange(value);
        this.model.getTransport().changePosition(speed > 0.0, ((MaschineControlSurface)this.surface).isKnobSensitivitySlow());
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay().clear();
        ITransport transport = this.model.getTransport();
        double tempo = transport.getTempo();
        d.setCell(0, 0, "Tempo:").setBlock(0, 1, String.format("  %.02f", tempo));
        d.setBlock(0, 2, "Time:").setBlock(0, 3, "> " + transport.getPositionText());
        d.setBlock(1, 2, "Position:").setBlock(1, 3, "> " + transport.getBeatText());
        d.allDone();
    }
}

