/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.continuous;

import de.mossgrabers.controller.ni.maschine.core.RibbonMode;
import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.utils.ButtonEvent;

public class TouchstripCommand
extends AbstractContinuousCommand<MaschineControlSurface, MaschineConfiguration>
implements TriggerCommand {
    private int ribbonValue = 0;

    public TouchstripCommand(IModel model, MaschineControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(int value) {
        this.ribbonValue = value;
        MaschineConfiguration config = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
        RibbonMode ribbonMode = config.getRibbonMode();
        switch (ribbonMode) {
            case PITCH_DOWN: {
                ((MaschineControlSurface)this.surface).sendMidiEvent(224, 0, (127 - value) / 2);
                break;
            }
            case PITCH_UP: {
                ((MaschineControlSurface)this.surface).sendMidiEvent(224, 0, 64 + value / 2);
                break;
            }
            case PITCH_DOWN_UP: {
                ((MaschineControlSurface)this.surface).sendMidiEvent(224, 0, value);
                break;
            }
            case CC_1: {
                ((MaschineControlSurface)this.surface).sendMidiEvent(176, 1, value);
                break;
            }
            case CC_11: {
                ((MaschineControlSurface)this.surface).sendMidiEvent(176, 11, value);
                break;
            }
            case MASTER_VOLUME: {
                this.model.getMasterTrack().setVolume(this.model.getValueChanger().toDAWValue(value));
                break;
            }
            case NOTE_REPEAT_PERIOD: 
            case NOTE_REPEAT_LENGTH: {
                Resolution[] values = Resolution.values();
                double scaled = (double)(127 - value) / 127.0;
                int index = (int)Math.round(scaled * (double)(values.length - 1));
                double resolutionValue = values[values.length - 1 - index].getValue();
                INoteRepeat noteRepeat = ((MaschineControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
                if (ribbonMode == RibbonMode.NOTE_REPEAT_PERIOD) {
                    noteRepeat.setPeriod(resolutionValue);
                    break;
                }
                noteRepeat.setNoteLength(resolutionValue);
                break;
            }
        }
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.UP) {
            return;
        }
        MaschineConfiguration config = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
        RibbonMode ribbonMode = config.getRibbonMode();
        switch (ribbonMode) {
            case PITCH_DOWN: 
            case PITCH_UP: {
                this.ribbonValue = 0;
                ((MaschineControlSurface)this.surface).sendMidiEvent(224, 0, 64);
                break;
            }
            case PITCH_DOWN_UP: {
                this.ribbonValue = 64;
                ((MaschineControlSurface)this.surface).sendMidiEvent(224, 0, 64);
                break;
            }
            case CC_1: 
            case CC_11: 
            case MASTER_VOLUME: 
            case NOTE_REPEAT_PERIOD: 
            case NOTE_REPEAT_LENGTH: {
                break;
            }
        }
    }

    public void resetRibbonValue(RibbonMode ribbonMode) {
        switch (ribbonMode) {
            case PITCH_DOWN: 
            case PITCH_UP: 
            case CC_1: 
            case CC_11: {
                this.ribbonValue = 0;
                break;
            }
            case PITCH_DOWN_UP: {
                this.ribbonValue = 64;
                break;
            }
        }
    }

    public void updateValue() {
        RibbonMode ribbonMode = ((MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration()).getRibbonMode();
        switch (ribbonMode) {
            case PITCH_DOWN: 
            case PITCH_UP: 
            case PITCH_DOWN_UP: 
            case CC_1: 
            case CC_11: {
                ((MaschineControlSurface)this.surface).setRibbonValue(this.ribbonValue);
                break;
            }
            case MASTER_VOLUME: {
                IMasterTrack t = this.model.getMasterTrack();
                ((MaschineControlSurface)this.surface).setRibbonValue(t == null ? 0 : this.model.getValueChanger().toMidiValue(t.getVolume()));
                break;
            }
            case NOTE_REPEAT_PERIOD: 
            case NOTE_REPEAT_LENGTH: {
                Resolution[] values = Resolution.values();
                INoteRepeat noteRepeat = ((MaschineControlSurface)this.surface).getMidiInput().getDefaultNoteInput().getNoteRepeat();
                double value = ribbonMode == RibbonMode.NOTE_REPEAT_PERIOD ? noteRepeat.getPeriod() : noteRepeat.getNoteLength();
                int index = Resolution.getMatch(value);
                ((MaschineControlSurface)this.surface).setRibbonValue((int)Math.round((double)index * 127.0 / (double)(values.length - 1)));
                break;
            }
        }
    }
}

