/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.parameter.IParameter;

public class InstrumentDeviceHandler
extends AbstractHandler {
    public InstrumentDeviceHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_WINDOW, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_BYPASS, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_EXPAND, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETERS, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PREVIOUS_PARAMETER_PAGE, FlexiCommand.INSTRUMENT_DEVICE_SELECT_NEXT_PARAMETER_PAGE, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_1, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_2, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_3, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_4, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_5, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_6, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_7, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_8, FlexiCommand.INSTRUMENT_DEVICE_SCROLL_PARAMETER_PAGES, FlexiCommand.INSTRUMENT_DEVICE_SELECT_PREVIOUS_PARAMETER_BANK, FlexiCommand.INSTRUMENT_DEVICE_SELECT_NEXT_PARAMETER_BANK, FlexiCommand.INSTRUMENT_DEVICE_SCROLL_PARAMETER_BANKS, FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_1, FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_2, FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_3, FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_4, FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_5, FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_6, FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_7, FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_8, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_1, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_2, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_3, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_4, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_5, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_6, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_7, FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_8, FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_1, FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_2, FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_3, FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_4, FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_5, FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_6, FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_7, FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        ISpecificDevice device = this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        switch (command) {
            case INSTRUMENT_DEVICE_TOGGLE_WINDOW: {
                return InstrumentDeviceHandler.toMidiValue(device.isWindowOpen());
            }
            case INSTRUMENT_DEVICE_TOGGLE_BYPASS: {
                return InstrumentDeviceHandler.toMidiValue(!device.isEnabled());
            }
            case INSTRUMENT_DEVICE_TOGGLE_EXPAND: {
                return InstrumentDeviceHandler.toMidiValue(device.isExpanded());
            }
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETERS: {
                return InstrumentDeviceHandler.toMidiValue(device.isParameterPageSectionVisible());
            }
            case INSTRUMENT_DEVICE_SET_PARAMETER_1: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_2: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_3: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_4: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_5: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_6: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_7: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_8: {
                return ((IParameter)device.getParameterBank().getItem(command.ordinal() - FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_1.ordinal())).getValue();
            }
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_1: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_2: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_3: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_4: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_5: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_6: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_7: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_8: {
                int value = ((IParameter)device.getParameterBank().getItem(command.ordinal() - FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_1.ordinal())).getValue();
                return InstrumentDeviceHandler.toMidiValue(value > 0);
            }
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_1: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_2: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_3: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_4: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_5: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_6: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_7: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_8: {
                return ((IParameter)device.getParameterBank().getItem(command.ordinal() - FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_1.ordinal())).isSelected() ? 127 : 0;
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        ISpecificDevice device = this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case INSTRUMENT_DEVICE_TOGGLE_WINDOW: {
                if (!isButtonPressed) break;
                device.toggleWindowOpen();
                break;
            }
            case INSTRUMENT_DEVICE_TOGGLE_BYPASS: {
                if (!isButtonPressed) break;
                device.toggleEnabledState();
                break;
            }
            case INSTRUMENT_DEVICE_TOGGLE_EXPAND: {
                if (!isButtonPressed) break;
                device.toggleExpanded();
                break;
            }
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETERS: {
                if (!isButtonPressed) break;
                device.toggleParameterPageSectionVisible();
                break;
            }
            case INSTRUMENT_DEVICE_SELECT_PREVIOUS_PARAMETER_PAGE: {
                if (!isButtonPressed) break;
                device.getParameterBank().scrollBackwards();
                break;
            }
            case INSTRUMENT_DEVICE_SELECT_NEXT_PARAMETER_PAGE: {
                if (!isButtonPressed) break;
                device.getParameterBank().scrollForwards();
                break;
            }
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_1: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_2: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_3: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_4: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_5: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_6: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_7: 
            case INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_8: {
                if (!isButtonPressed) break;
                device.getParameterBank().getPageBank().selectPage(command.ordinal() - FlexiCommand.INSTRUMENT_DEVICE_SELECT_PARAMETER_PAGE_1.ordinal());
                this.mvHelper.notifySelectedDeviceAndParameterPage();
                break;
            }
            case INSTRUMENT_DEVICE_SCROLL_PARAMETER_PAGES: {
                this.scrollParameterPage(knobMode, value);
                break;
            }
            case INSTRUMENT_DEVICE_SELECT_PREVIOUS_PARAMETER_BANK: {
                if (!isButtonPressed) break;
                device.getParameterBank().selectPreviousPage();
                break;
            }
            case INSTRUMENT_DEVICE_SELECT_NEXT_PARAMETER_BANK: {
                if (!isButtonPressed) break;
                device.getParameterBank().selectNextPage();
                break;
            }
            case INSTRUMENT_DEVICE_SCROLL_PARAMETER_BANKS: {
                this.scrollParameterBank(knobMode, value);
                break;
            }
            case INSTRUMENT_DEVICE_SET_PARAMETER_1: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_2: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_3: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_4: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_5: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_6: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_7: 
            case INSTRUMENT_DEVICE_SET_PARAMETER_8: {
                this.handleParameter(knobMode, command.ordinal() - FlexiCommand.INSTRUMENT_DEVICE_SET_PARAMETER_1.ordinal(), value);
                break;
            }
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_1: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_2: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_3: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_4: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_5: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_6: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_7: 
            case INSTRUMENT_DEVICE_TOGGLE_PARAMETER_8: {
                IParameter toggleParam = (IParameter)device.getParameterBank().getItem(command.ordinal() - FlexiCommand.INSTRUMENT_DEVICE_TOGGLE_PARAMETER_1.ordinal());
                if (!isButtonPressed) break;
                int v = toggleParam.getValue();
                toggleParam.setValue(v > 0 ? 0 : this.model.getValueChanger().getUpperBound() - 1);
                break;
            }
            case INSTRUMENT_DEVICE_RESET_PARAMETER_1: 
            case INSTRUMENT_DEVICE_RESET_PARAMETER_2: 
            case INSTRUMENT_DEVICE_RESET_PARAMETER_3: 
            case INSTRUMENT_DEVICE_RESET_PARAMETER_4: 
            case INSTRUMENT_DEVICE_RESET_PARAMETER_5: 
            case INSTRUMENT_DEVICE_RESET_PARAMETER_6: 
            case INSTRUMENT_DEVICE_RESET_PARAMETER_7: 
            case INSTRUMENT_DEVICE_RESET_PARAMETER_8: {
                if (!isButtonPressed) break;
                ((IParameter)device.getParameterBank().getItem(command.ordinal() - FlexiCommand.INSTRUMENT_DEVICE_RESET_PARAMETER_1.ordinal())).resetValue();
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void scrollParameterPage(KnobMode knobMode, MidiValue value) {
        if (InstrumentDeviceHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        ISpecificDevice device = this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        IParameterBank parameterBank = device.getParameterBank();
        if (this.isIncrease(knobMode, value)) {
            parameterBank.scrollForwards();
        } else {
            parameterBank.scrollBackwards();
        }
        this.mvHelper.notifySelectedParameterPage();
    }

    private void scrollParameterBank(KnobMode knobMode, MidiValue value) {
        if (InstrumentDeviceHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        ISpecificDevice device = this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        IParameterBank parameterBank = device.getParameterBank();
        if (this.isIncrease(knobMode, value)) {
            parameterBank.selectNextPage();
        } else {
            parameterBank.selectPreviousPage();
        }
        this.mvHelper.notifySelectedParameterPage();
    }

    private void handleParameter(KnobMode knobMode, int index, MidiValue value) {
        IParameter fxParam = (IParameter)this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT).getParameterBank().getItem(index);
        int val = value.getValue();
        if (InstrumentDeviceHandler.isAbsolute(knobMode)) {
            fxParam.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            fxParam.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }
}

