/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.faderfox.ec4;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IActionSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import java.util.List;

public class EC4Configuration
extends AbstractConfiguration {
    public static final Integer SETUP_SLOT = 100;
    private static final String[] SETUP_SLOTS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"};
    private static final String CATEGORY_ASSIGNABLE_BUTTONS = "Functions";
    private int setupSlot = 0;
    private final String[] assignableFunctionActions = new String[4];

    public EC4Configuration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateHardwareSettings(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateAssignableSettings(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
    }

    private void activateHardwareSettings(ISettingsUI settingsUI) {
        IEnumSetting setupSlotSetting = settingsUI.getEnumSetting("Setup slot which contains the DrivenByMoss template", "Hardware Setup", SETUP_SLOTS, SETUP_SLOTS[0]);
        setupSlotSetting.addValueObserver(value -> {
            this.setupSlot = Integer.parseInt(value) - 1;
            this.notifyObservers(SETUP_SLOT);
        });
        this.isSettingActive.add(SETUP_SLOT);
    }

    private void activateAssignableSettings(ISettingsUI settingsUI) {
        for (int i = 0; i < this.assignableFunctionActions.length; ++i) {
            int pos = i;
            IActionSetting actionSetting = settingsUI.getActionSetting("User " + (i + 1), CATEGORY_ASSIGNABLE_BUTTONS);
            actionSetting.addValueObserver(value -> {
                this.assignableFunctionActions[pos] = (String)actionSetting.get();
            });
        }
    }

    public int getSetupSlot() {
        return this.setupSlot;
    }

    public String getAssignableAction(int index) {
        return this.assignableFunctionActions[index];
    }
}

