/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.mode;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueComponent;
import de.mossgrabers.framework.mode.AbstractNoteParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;
import java.util.List;

public class FireNoteMode
extends AbstractNoteParameterMode<FireControlSurface, FireConfiguration, IItem> {
    protected static final List<ContinuousID> KNOB_IDS = ContinuousID.createSequentialList(ContinuousID.KNOB1, 4);
    private final FixedParameterProvider provider;
    private final FixedParameterProvider altProvider;
    private final NoteParameter transposeParameter;

    public FireNoteMode(FireControlSurface surface, IModel model) {
        super("Note Edit", surface, model, false, null, KNOB_IDS);
        IValueChanger valueChanger = model.getValueChanger();
        this.transposeParameter = new NoteParameter(NoteAttribute.TRANSPOSE, null, model, this.noteEditor, valueChanger);
        this.provider = new FixedParameterProvider(new NoteParameter(NoteAttribute.GAIN, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.PANNING, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.DURATION, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY, null, model, this.noteEditor, valueChanger), this.transposeParameter);
        this.altProvider = new FixedParameterProvider(new NoteParameter(NoteAttribute.PRESSURE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.TIMBRE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.CHANCE, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.VELOCITY_SPREAD, null, model, this.noteEditor, valueChanger), new NoteParameter(NoteAttribute.REPEAT, null, model, this.noteEditor, valueChanger));
        this.setParameterProvider(this.provider);
        this.setParameterProvider(ButtonID.ALT, this.altProvider);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        INoteClip clip = this.noteEditor.getClip();
        if (clip == null || this.isKnobTouched(index) == isTouched) {
            return;
        }
        this.setTouchedKnob(index, isTouched);
        if (isTouched) {
            clip.startEdit(this.noteEditor.getNotes());
            this.preventNoteDeletion();
        } else {
            clip.stopEdit();
        }
    }

    private void preventNoteDeletion() {
        IView activeView = (IView)((FireControlSurface)this.surface).getViewManager().getActive();
        if (activeView instanceof AbstractSequencerView) {
            AbstractSequencerView sequencerView = (AbstractSequencerView)activeView;
            sequencerView.setNoteEdited();
        }
    }

    @Override
    public void updateDisplay() {
        IParameter parameter;
        Object desc;
        List<NotePosition> notes = this.noteEditor.getNotes();
        if (notes.isEmpty()) {
            desc = "Select a note";
        } else if (notes.size() > 1) {
            desc = notes.size() + " notes sel.";
        } else {
            NotePosition notePosition = notes.get(0);
            desc = "Step: " + (notePosition.getStep() + 1) + " - " + Scales.formatNoteAndOctave(notePosition.getNote(), -3);
        }
        Object paramLine = "";
        int value = -1;
        int touchedKnob = this.getTouchedKnob();
        if (touchedKnob != -1 && (parameter = (((FireControlSurface)this.surface).isPressed(ButtonID.ALT) ? this.altProvider : this.provider).get(touchedKnob)) != null) {
            value = parameter.getValue();
            paramLine = parameter.getName(5) + ": " + parameter.getDisplayedValue();
        }
        IGraphicDisplay display = ((FireControlSurface)this.surface).getGraphicsDisplay();
        display.addElement(new TitleValueComponent((String)desc, (String)paramLine, value, false));
        display.send();
    }

    public void resetTranspose() {
        this.transposeParameter.resetValue();
    }

    static {
        KNOB_IDS.add(ContinuousID.VIEW_SELECTION);
    }
}

