/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.controller;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColor;

public class FireColorManager
extends ColorManager {
    public static final String BUTTON_STATE_ON2 = "BUTTON_STATE_ON2";
    public static final String BUTTON_STATE_HI2 = "BUTTON_STATE_HI2";
    private static final int DAW_COLOR_START = 100;
    private static final int SCALE_COLOR_OCTAVE = 50;
    private static final int SCALE_COLOR_NOTE = 51;
    private static final int SCALE_COLOR_OUT_OF_SCALE = 52;
    public static final int FIRE_COLOR_BLACK = 0;
    public static final int FIRE_COLOR_WHITE = 59;
    public static final int FIRE_COLOR_GREEN = 60;
    public static final int FIRE_COLOR_DARK_GREEN = 61;
    public static final int FIRE_COLOR_RED = 62;
    public static final int FIRE_COLOR_DARK_RED = 63;
    public static final int FIRE_COLOR_DARKER_RED = 64;
    public static final int FIRE_COLOR_BLUE = 65;
    public static final int FIRE_COLOR_DARK_BLUE = 66;
    public static final int FIRE_COLOR_DARK_OCEAN = 67;
    public static final int FIRE_COLOR_ORANGE = 68;
    public static final int FIRE_COLOR_DARK_ORANGE = 69;
    public static final int FIRE_COLOR_DARKER_ORANGE = 70;
    public static final int FIRE_COLOR_YELLOW = 71;
    public static final int FIRE_COLOR_DARK_YELLOW = 72;
    public static final int FIRE_COLOR_DARKER_YELLOW = 73;
    public static final int FIRE_COLOR_BROWN = 74;
    public static final int FIRE_COLOR_GRAY = 75;

    public FireColorManager() {
        this.registerColorIndex("SCALE_COLOR_OFF", 0);
        this.registerColorIndex("SCALE_COLOR_OCTAVE", 50);
        this.registerColorIndex("SCALE_COLOR_NOTE", 51);
        this.registerColorIndex("SCALE_COLOR_OUT_OF_SCALE", 52);
        this.registerColorIndex("GRID_COLOR_OFF", 0);
        this.registerColorIndex("COLOR_STEP_HILITE_NO_CONTENT", 61);
        this.registerColorIndex("COLOR_STEP_HILITE_CONTENT", 60);
        this.registerColorIndex("COLOR_STEP_MUTED", 75);
        this.registerColorIndex("COLOR_STEP_MUTED_CONT", 75);
        this.registerColorIndex("COLOR_STEP_SELECTED", 73);
        this.registerColorIndex("COLOR_NO_CONTENT", 0);
        this.registerColorIndex("COLOR_NO_CONTENT_4", 75);
        this.registerColorIndex("COLOR_CONTENT", 65);
        this.registerColorIndex("COLOR_CONTENT_CONT", 66);
        this.registerColorIndex("COLOR_PAGE", 75);
        this.registerColorIndex("COLOR_ACTIVE_PAGE", 62);
        this.registerColorIndex("COLOR_SELECTED_PAGE", 64);
        this.registerColorIndex("COLOR_RESOLUTION", 69);
        this.registerColorIndex("COLOR_RESOLUTION_SELECTED", 68);
        this.registerColorIndex("COLOR_RESOLUTION_OFF", 0);
        this.registerColorIndex("COLOR_TRANSPOSE", 59);
        this.registerColorIndex("COLOR_TRANSPOSE_SELECTED", 71);
        this.registerColorIndex("COLOR_PAD_OFF", 0);
        this.registerColorIndex("COLOR_PAD_RECORD", 62);
        this.registerColorIndex("COLOR_PAD_PLAY", 60);
        this.registerColorIndex("COLOR_PAD_SELECTED", 65);
        this.registerColorIndex("COLOR_PAD_MUTED", 74);
        this.registerColorIndex("COLOR_PAD_HAS_CONTENT", 71);
        this.registerColorIndex("COLOR_PAD_NO_CONTENT", 72);
        this.registerColorIndex("PLAY_VIEW_COLOR_OFF", 0);
        this.registerColorIndex("PLAY_VIEW_COLOR_PLAY", 60);
        this.registerColorIndex("PLAY_VIEW_COLOR_RECORD", 62);
        this.registerColorIndex("COLOR_SCENE", 61);
        this.registerColorIndex("COLOR_SELECTED_SCENE", 60);
        this.registerColorIndex("COLOR_SELECTED_OFF", 0);
        this.registerColorIndex("BUTTON_COLOR_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_ON", 1);
        this.registerColorIndex("BUTTON_STATE_HI", 3);
        this.registerColorIndex(BUTTON_STATE_ON2, 2);
        this.registerColorIndex(BUTTON_STATE_HI2, 4);
        this.registerColor(0, ColorEx.BLACK);
        this.registerColor(59, ColorEx.WHITE);
        this.registerColor(60, ColorEx.GREEN);
        this.registerColor(61, ColorEx.DARK_GREEN);
        this.registerColor(62, ColorEx.RED);
        this.registerColor(63, ColorEx.DARK_RED);
        this.registerColor(64, ColorEx.fromRGB(20, 0, 0));
        this.registerColor(65, ColorEx.BLUE);
        this.registerColor(66, ColorEx.DARK_BLUE);
        this.registerColor(67, ColorEx.SKY_BLUE);
        this.registerColor(68, ColorEx.ORANGE);
        this.registerColor(69, ColorEx.DARK_ORANGE);
        this.registerColor(70, ColorEx.fromRGB(32, 14, 0));
        this.registerColor(72, ColorEx.DARK_YELLOW);
        this.registerColor(71, ColorEx.YELLOW);
        this.registerColor(73, ColorEx.fromRGB(20, 20, 0));
        this.registerColor(74, ColorEx.BROWN);
        this.registerColor(75, ColorEx.GRAY);
        this.registerColor(50, ColorEx.BLUE);
        this.registerColor(51, ColorEx.WHITE);
        this.registerColor(52, ColorEx.DARK_GRAY);
        DAWColor[] values = DAWColor.values();
        for (int i = 0; i < values.length; ++i) {
            this.registerColorIndex(values[i], 100 + i);
        }
    }

    @Override
    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        if (ButtonID.isPad(buttonID)) {
            if (colorIndex >= 100) {
                return DAWColor.getColorEntry(colorIndex - 100);
            }
            return super.getColor(colorIndex, buttonID);
        }
        if (colorIndex == 0) {
            return ColorEx.BLACK;
        }
        switch (buttonID) {
            case ARROW_UP: 
            case ARROW_DOWN: 
            case ARROW_LEFT: 
            case ARROW_RIGHT: 
            case BROWSE: {
                return colorIndex == 1 ? ColorEx.DARK_RED : ColorEx.RED;
            }
            case ROW_SELECT_1: 
            case ROW_SELECT_2: 
            case ROW_SELECT_3: 
            case ROW_SELECT_4: 
            case SCENE1: 
            case SCENE2: 
            case SCENE3: 
            case SCENE4: {
                return colorIndex == 1 ? ColorEx.DARK_GREEN : ColorEx.GREEN;
            }
            case ALT: 
            case STOP: {
                return colorIndex == 1 ? ColorEx.DARK_ORANGE : ColorEx.ORANGE;
            }
            case SEQUENCER: 
            case NOTE: 
            case DRUM: 
            case SESSION: 
            case SHIFT: 
            case RECORD: {
                switch (colorIndex) {
                    case 1: {
                        return ColorEx.DARK_RED;
                    }
                    case 2: {
                        return ColorEx.DARK_ORANGE;
                    }
                    case 3: {
                        return ColorEx.RED;
                    }
                    case 4: {
                        return ColorEx.ORANGE;
                    }
                }
                return ColorEx.BLACK;
            }
            case METRONOME: 
            case PLAY: {
                switch (colorIndex) {
                    case 1: {
                        return ColorEx.DARK_GREEN;
                    }
                    case 2: {
                        return ColorEx.DARK_ORANGE;
                    }
                    case 3: {
                        return ColorEx.GREEN;
                    }
                    case 4: {
                        return ColorEx.ORANGE;
                    }
                }
                return ColorEx.BLACK;
            }
        }
        return ColorEx.BLACK;
    }
}

