/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.command.trigger;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SendModeCommand
extends AbstractTriggerCommand<APCControlSurface, APCConfiguration> {
    private final int sendIndex;

    public SendModeCommand(int sendIndex, IModel model, APCControlSurface surface) {
        super(model, surface);
        this.sendIndex = sendIndex;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        this.handleExecute(event, this.sendIndex);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        this.handleExecute(event, this.sendIndex + 3);
    }

    private void handleExecute(ButtonEvent event, int sendIndex) {
        if (event != ButtonEvent.DOWN || this.model.isEffectTrackBankActive()) {
            return;
        }
        ModeManager modeManager = ((APCControlSurface)this.surface).getModeManager();
        modeManager.setActive(Modes.get(Modes.SEND1, sendIndex));
        this.mvHelper.notifySelectedSend(sendIndex);
    }
}

