/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.command.continuous;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.command.TempoCommand;
import de.mossgrabers.framework.command.continuous.PlayPositionCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.Timeout;
import de.mossgrabers.framework.view.Views;

public class APCPlayPositionCommand
extends PlayPositionCommand<APCControlSurface, APCConfiguration> {
    private final TempoCommand<APCControlSurface, APCConfiguration> tempoCommand;
    private final Timeout timeout;

    public APCPlayPositionCommand(IModel model, APCControlSurface surface, Timeout timeout) {
        super(model, surface);
        this.tempoCommand = new TempoCommand(model, surface);
        this.timeout = timeout;
    }

    @Override
    public void execute(int value) {
        if (((APCControlSurface)this.surface).isPressed(ButtonID.TAP_TEMPO)) {
            ((APCControlSurface)this.surface).setTriggerConsumed(ButtonID.TAP_TEMPO);
            this.tempoCommand.execute(value);
            ViewManager viewManager = ((APCControlSurface)this.surface).getViewManager();
            if (!viewManager.isActive(new Views[]{Views.TEMPO})) {
                viewManager.setTemporary(Views.TEMPO);
            }
            this.timeout.delay(viewManager::restore);
            return;
        }
        if (((APCControlSurface)this.surface).isPressed(ButtonID.ARROW_LEFT)) {
            ((APCControlSurface)this.surface).setTriggerConsumed(ButtonID.ARROW_LEFT);
            this.transport.changeLoopStart(this.model.getValueChanger().isIncrease(value), ((APCControlSurface)this.surface).isKnobSensitivitySlow());
            this.mvHelper.delayDisplay(() -> "Loop Start: " + this.transport.getLoopStartBeatText());
            return;
        }
        if (((APCControlSurface)this.surface).isPressed(ButtonID.ARROW_RIGHT)) {
            ((APCControlSurface)this.surface).setTriggerConsumed(ButtonID.ARROW_RIGHT);
            this.transport.changeLoopLength(this.model.getValueChanger().isIncrease(value), ((APCControlSurface)this.surface).isKnobSensitivitySlow());
            this.mvHelper.delayDisplay(() -> "Loop Length: " + this.transport.getLoopLengthBeatText());
            return;
        }
        super.execute(value);
    }
}

