/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.acvs.command.trigger;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class ACVSMasterCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private int position = 0;

    public ACVSMasterCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IMasterTrack masterTrack = this.model.getMasterTrack();
        ITrackBank trackBank = this.model.getTrackBank();
        if (masterTrack.isSelected()) {
            trackBank.selectItemAtPosition(this.position);
        } else {
            Optional selectedTrack = trackBank.getSelectedItem();
            this.position = selectedTrack.isPresent() ? ((ITrack)selectedTrack.get()).getPosition() : 0;
            masterTrack.select();
        }
    }
}

