/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.view;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.view.NoteRepeatSceneHelper;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractChordView;

public class ChordsView
extends AbstractChordView<PushControlSurface, PushConfiguration> {
    public ChordsView(PushControlSurface surface, IModel model) {
        this("Chords", surface, model);
    }

    public ChordsView(String name, PushControlSurface surface, IModel model) {
        super(name, surface, model, true);
        Object configuration = ((PushControlSurface)this.surface).getConfiguration();
        ChordsView chordsView = this;
        configuration.addSettingObserver(AbstractConfiguration.ACTIVATE_FIXED_ACCENT, () -> chordsView.initMaxVelocity());
        chordsView = this;
        configuration.addSettingObserver(AbstractConfiguration.FIXED_ACCENT_VALUE, () -> chordsView.initMaxVelocity());
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (ButtonID.isSceneButton(buttonID)) {
            this.onSceneButton(buttonID, event);
        }
    }

    @Override
    protected boolean handleSceneButtonCombinations(int index, IScene scene) {
        if (((PushControlSurface)this.surface).isPressed(ButtonID.REPEAT)) {
            NoteRepeatSceneHelper.handleNoteRepeatSelection((PushControlSurface)this.surface, 7 - index);
            return true;
        }
        return super.handleSceneButtonCombinations(index, scene);
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene;
        if (!ButtonID.isSceneButton(buttonID)) {
            return "BUTTON_COLOR_OFF";
        }
        if (((PushControlSurface)this.surface).isPressed(ButtonID.REPEAT)) {
            return NoteRepeatSceneHelper.getButtonColorID((PushControlSurface)this.surface, buttonID);
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal());
        if (s.doesExist()) {
            return s.isSelected() ? "COLOR_SELECTED_SCENE" : "COLOR_SCENE";
        }
        return "COLOR_SELECTED_OFF";
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (this.isButtonCombination(ButtonID.DELETE)) {
            int editMidiChannel = ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getMidiEditChannel();
            this.model.getNoteClip(8, 128).clearRow(editMidiChannel, this.keyManager.map(note));
            return;
        }
        super.onGridNote(note, velocity);
    }
}

