/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.configuration;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.configuration.AbstractConfigurationMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.resource.ChannelType;

public class AudioConfigurationMode
extends AbstractConfigurationMode {
    public AudioConfigurationMode(PushControlSurface surface, IModel model) {
        super(3, "Audio Configuration", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 0: {
                config.changePedal1(value);
                break;
            }
            case 1: {
                config.changePedal2(value);
                break;
            }
            case 3: {
                config.changePreamp1Type(value);
                break;
            }
            case 4: {
                config.changePreamp1Gain(value);
                break;
            }
            case 5: {
                config.changePreamp2Type(value);
                break;
            }
            case 6: {
                config.changePreamp2Gain(value);
                break;
            }
            case 7: {
                config.changeAudioOutputs(value);
                break;
            }
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (!isTouched || !((PushControlSurface)this.surface).isDeletePressed()) {
            return;
        }
        ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 0: {
                config.setPedal1(0);
                break;
            }
            case 1: {
                config.setPedal2(0);
                break;
            }
            case 3: {
                config.setPreamp1Type(0);
                break;
            }
            case 4: {
                config.setPreamp1Gain(0);
                break;
            }
            case 5: {
                config.setPreamp2Type(0);
                break;
            }
            case 6: {
                config.setPreamp2Gain(0);
                break;
            }
            case 7: {
                config.setAudioOutputs(0);
                break;
            }
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int useCV1 = config.getPedal1();
        int useCV2 = config.getPedal2();
        int preampType1 = config.getPreamp1Type();
        int preampType2 = config.getPreamp2Type();
        int preampGain1 = config.getPreamp1Gain();
        int preampGain2 = config.getPreamp2Gain();
        int outputs = config.getAudioOutputs();
        display.addParameterElement(this.menu[0], false, "", (ChannelType)null, null, false, "Pedal&CV 1", useCV1 > 0 ? 1023 : 0, PushConfiguration.FOOT_CV_OPTIONS[useCV1], this.isKnobTouched(0), -1);
        display.addParameterElement(this.menu[1], false, "", (ChannelType)null, null, false, "Pedal&CV 2", useCV2 > 0 ? 1023 : 0, PushConfiguration.FOOT_CV_OPTIONS[useCV2], this.isKnobTouched(1), -1);
        display.addOptionElement("   Preamp", this.menu[2], false, "", "", false, true);
        display.addParameterElement(this.menu[3], true, "", (ChannelType)null, null, false, "P1: Type", preampType1 * 1023 / (PushConfiguration.PREAMP_TYPE_OPTIONS.length - 1), PushConfiguration.PREAMP_TYPE_OPTIONS[preampType1], this.isKnobTouched(3), -1);
        display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "P1: Gain", preampGain1 * 1023 / (PushConfiguration.PREAMP_GAIN_OPTIONS.length - 1), PushConfiguration.PREAMP_GAIN_OPTIONS[preampGain1], this.isKnobTouched(4), -1);
        display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "P2: Type", preampType2 * 1023 / (PushConfiguration.PREAMP_TYPE_OPTIONS.length - 1), PushConfiguration.PREAMP_TYPE_OPTIONS[preampType2], this.isKnobTouched(5), -1);
        display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "P2: Gain", preampGain2 * 1023 / (PushConfiguration.PREAMP_GAIN_OPTIONS.length - 1), PushConfiguration.PREAMP_GAIN_OPTIONS[preampGain2], this.isKnobTouched(6), -1);
        display.addParameterElement(" ", false, "", (ChannelType)null, null, false, "Outputs", outputs * 1023 / (PushConfiguration.OUTPUT_CONFIGURATION_SHORT.length - 1), PushConfiguration.OUTPUT_CONFIGURATION_SHORT[outputs], this.isKnobTouched(7), -1);
    }
}

