/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument;

import java.io.Serializable;
import java.time.Instant;
import java.util.Date;

public class OSCTimeTag64
implements Cloneable,
Serializable,
Comparable<OSCTimeTag64> {
    public static final long EPOCH_LENGTH_JAVA_TIME = 4294967296000L;
    public static final long EPOCH_START_JAVA_TIME_0 = -2208992400000L;
    public static final long EPOCH_START_JAVA_TIME_CURRENT = OSCTimeTag64.findEpochStartJavaTime(new Date().getTime());
    public static final long IMMEDIATE_RAW = 1L;
    public static final OSCTimeTag64 IMMEDIATE = OSCTimeTag64.valueOf(1L);
    private static final long FILTER_LOWER_32 = 0xFFFFFFFFL;
    private static final int NTP_SECONDS_BITS = 32;
    private static final double FRACTION_TO_NANOS_MULTIPLIER = 0.23283;
    private static final long serialVersionUID = 1L;
    private final long ntpTime;

    protected OSCTimeTag64(long ntpTime) {
        this.ntpTime = ntpTime;
    }

    public long getNtpTime() {
        return this.ntpTime;
    }

    public long getSeconds() {
        return this.ntpTime >>> 32;
    }

    public long getFraction() {
        return this.ntpTime & 0xFFFFFFFFL;
    }

    public int getNanos() {
        return (int)Math.round((double)this.getFraction() * 0.23283);
    }

    public boolean isImmediate() {
        return this.ntpTime == 1L;
    }

    public boolean equals(Object other) {
        return other instanceof OSCTimeTag64 && this.getNtpTime() == ((OSCTimeTag64)other).getNtpTime();
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (int)(this.ntpTime ^ this.ntpTime >>> 32);
        return hash;
    }

    @Override
    public int compareTo(OSCTimeTag64 other) {
        return 10 * Long.signum(Long.compare(this.getSeconds(), other.getSeconds())) + Long.signum(Long.compare(this.getFraction(), other.getFraction()));
    }

    public OSCTimeTag64 clone() throws CloneNotSupportedException {
        return (OSCTimeTag64)super.clone();
    }

    public Date toDate(long epochIndicatorTime) {
        return new Date(this.toJavaTime(epochIndicatorTime));
    }

    public Date toDate(Date epochIndicator) {
        return epochIndicator == null ? this.toDate() : this.toDate(epochIndicator.getTime());
    }

    private Date toDate() {
        return new Date(this.toJavaTimeInEpoch(EPOCH_START_JAVA_TIME_CURRENT));
    }

    private static long findEpochStartJavaTime(long javaTime) {
        long epochIndex = (javaTime - -2208992400000L) / 4294967296000L;
        return -2208992400000L + epochIndex * 4294967296000L;
    }

    private long toJavaTimeInEpoch(long epochStart) {
        long secondsInMs = this.getSeconds() * 1000L;
        long fractionInMs = Math.round(1000.0 * (double)this.getFraction() / 4.294967296E9);
        return epochStart + (secondsInMs | fractionInMs);
    }

    private long toJavaTime(Long epochIndicatorTime) {
        long epochStart = epochIndicatorTime == null ? EPOCH_START_JAVA_TIME_CURRENT : OSCTimeTag64.findEpochStartJavaTime(epochIndicatorTime);
        return this.toJavaTimeInEpoch(epochStart);
    }

    private static long toNtpTimeTag(long seconds, long fraction) {
        return seconds << 32 | fraction;
    }

    public Instant toInstant() {
        return Instant.ofEpochSecond(this.getSeconds(), this.getNanos());
    }

    public static OSCTimeTag64 valueOf(Instant instant) {
        return OSCTimeTag64.valueOf(instant.getEpochSecond(), Math.round((double)instant.getNano() / 0.23283));
    }

    public static OSCTimeTag64 valueOf(long ntpTime) {
        return new OSCTimeTag64(ntpTime);
    }

    public static OSCTimeTag64 valueOf(long seconds, long fraction) {
        return new OSCTimeTag64(OSCTimeTag64.toNtpTimeTag(seconds, fraction));
    }

    public static OSCTimeTag64 valueOf(Date javaTime) {
        return new OSCTimeTag64(OSCTimeTag64.javaToNtpTimeStamp(javaTime.getTime()));
    }

    public String toString() {
        return this.toDate().toString();
    }

    private static long javaToNtpTimeStamp(long javaTime) {
        long epochStart = OSCTimeTag64.findEpochStartJavaTime(javaTime);
        long millisecondsInEpoch = javaTime - epochStart;
        long seconds = millisecondsInEpoch / 1000L;
        long fraction = Math.round((double)(millisecondsInEpoch % 1000L * 0x100000000L) / 1000.0);
        return OSCTimeTag64.toNtpTimeTag(seconds, fraction);
    }

    public static Date immediateDate() {
        return IMMEDIATE.toDate(new Date(-2208992400000L));
    }
}

