/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.midi;

import de.mossgrabers.framework.daw.midi.AbstractNoteInput;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.framework.midi.NoteRepeatImpl;
import de.mossgrabers.reaper.framework.midi.ReaperMidiDevice;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import javax.sound.midi.MidiDevice;

public class NoteInputImpl
extends AbstractNoteInput {
    private final BackendExchange sender;
    private final MidiDevice device;
    private final int noteInputIndex;

    public NoteInputImpl(MidiDevice device, int noteInputIndex, BackendExchange sender, String ... filters) {
        this.sender = sender;
        this.device = device;
        this.noteInputIndex = noteInputIndex;
        HashSet<String> backendFilters = new HashSet<String>();
        if (filters.length == 0) {
            backendFilters.add("90");
            backendFilters.add("80");
            backendFilters.add("B001");
            backendFilters.add("B00B");
            backendFilters.add("B040");
            backendFilters.add("E0");
            backendFilters.add("D0");
            backendFilters.add("A0");
        } else {
            for (String filter : filters) {
                if (filter.length() != 6) {
                    throw new IllegalArgumentException("Filter must be 6 characters long!");
                }
                String status = filter.substring(0, 2).replace('?', ' ').trim();
                String data1 = filter.substring(2, 4).replace('?', ' ').trim();
                String data2 = filter.substring(4, 6).replace('?', ' ').trim();
                if (status.length() == 0) {
                    throw new IllegalArgumentException("Filter has missing status!");
                }
                if (data1.length() == 0 && data2.length() > 0) {
                    throw new IllegalArgumentException("First data byte filter cannot be empty if second is set!");
                }
                if (data1.length() == 1 || data2.length() == 1) {
                    throw new IllegalArgumentException("Can only handle 2 byte data byte filters!");
                }
                ArrayList<Object> results = new ArrayList<Object>();
                if (status.length() == 1) {
                    for (int i = 0; i <= 15; ++i) {
                        results.add(status + Integer.toHexString(i).toUpperCase(Locale.US));
                    }
                } else {
                    results.add(status);
                }
                for (String string : results) {
                    Object finalFilter = string;
                    if (data1.length() > 0) {
                        finalFilter = (String)finalFilter + data1;
                        if (data2.length() > 0) {
                            finalFilter = (String)finalFilter + data2;
                        }
                    }
                    backendFilters.add((String)finalFilter);
                }
            }
        }
        this.noteRepeat = new NoteRepeatImpl(sender);
        if (device instanceof ReaperMidiDevice) {
            ReaperMidiDevice reaperMidiDevice = (ReaperMidiDevice)device;
            sender.setNoteInputFilters(reaperMidiDevice.getDeviceID(), this.noteInputIndex, backendFilters.toArray(new String[backendFilters.size()]));
        }
    }

    @Override
    public void setKeyTranslationTable(int[] table) {
        MidiDevice midiDevice = this.device;
        if (midiDevice instanceof ReaperMidiDevice) {
            ReaperMidiDevice reaperMidiDevice = (ReaperMidiDevice)midiDevice;
            this.sender.setNoteInputKeyTranslationTable(reaperMidiDevice.getDeviceID(), this.noteInputIndex, table);
        }
    }

    @Override
    public void setVelocityTranslationTable(int[] table) {
        MidiDevice midiDevice = this.device;
        if (midiDevice instanceof ReaperMidiDevice) {
            ReaperMidiDevice reaperMidiDevice = (ReaperMidiDevice)midiDevice;
            this.sender.setNoteInputVelocityTranslationTable(reaperMidiDevice.getDeviceID(), this.noteInputIndex, table);
        }
    }

    @Override
    public void enableMPE(boolean enable) {
        this.isMPEEnabled = enable;
    }

    @Override
    public void setMPEPitchBendSensitivity(int pitchBendRange) {
        this.mpePitchBendSensitivity = pitchBendRange;
    }
}

