/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import com.nikhaldimann.inieditor.IniEditor;
import de.mossgrabers.framework.daw.AbstractBrowser;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.FrameworkException;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.BrowserContentType;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.HostImpl;
import de.mossgrabers.reaper.framework.daw.data.CursorDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.ItemImpl;
import de.mossgrabers.reaper.framework.device.DeviceCollection;
import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.DeviceMetadataImpl;
import de.mossgrabers.reaper.framework.device.DeviceType;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceCategoryFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceCollectionFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceCreatorFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceFileTypeFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceLocationFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceTagsFilterColumn;
import de.mossgrabers.reaper.framework.device.column.DeviceTypeFilterColumn;
import de.mossgrabers.reaper.framework.device.column.EmptyFilterColumn;
import de.mossgrabers.reaper.ui.dialog.BrowserDialog;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;

public class BrowserImpl
extends AbstractBrowser {
    private static final String[] CONTENT_TYPE_NAMES = new String[]{"Devices", "Presets"};
    private static final Map<String, PresetFileCacheItem> presetFileCache = new HashMap<String, PresetFileCacheItem>();
    private BrowserContentType contentType = BrowserContentType.PRESET;
    private final ICursorDevice cursorDevice;
    final DeviceCollectionFilterColumn deviceCollectionFilterColumn;
    final DeviceLocationFilterColumn deviceLocationFilterColumn;
    final DeviceFileTypeFilterColumn deviceFileTypeFilterColumn;
    final DeviceCategoryFilterColumn deviceCategoryFilterColumn;
    final DeviceTagsFilterColumn deviceTagsFilterColumn;
    final DeviceCreatorFilterColumn deviceCreatorFilterColumn;
    final DeviceTypeFilterColumn deviceTypeFilterColumn;
    private boolean isBrowserActive = false;
    private final PresetModel presetModel = new PresetModel();
    int selectedIndex;
    List<DeviceMetadataImpl> filteredDevices = Collections.emptyList();
    private final BackendExchange sender;
    private final IBrowserColumn[][] columnDataContentTypes;
    private final BrowserDialog browserWindow;
    private int insertPosition;
    private final Object parsePresetFileLock = new Object();

    public BrowserImpl(DataSetupEx dataSetup, ICursorDevice cursorDevice, int numFilterColumnEntries, int numResults) {
        super(numFilterColumnEntries, numResults);
        this.cursorDevice = cursorDevice;
        this.sender = dataSetup.getSender();
        this.deviceCollectionFilterColumn = new DeviceCollectionFilterColumn(0, numFilterColumnEntries);
        this.deviceLocationFilterColumn = new DeviceLocationFilterColumn(1, numFilterColumnEntries);
        this.deviceFileTypeFilterColumn = new DeviceFileTypeFilterColumn(2, numFilterColumnEntries);
        this.deviceCategoryFilterColumn = new DeviceCategoryFilterColumn(3, numFilterColumnEntries);
        this.deviceTagsFilterColumn = new DeviceTagsFilterColumn(4, numFilterColumnEntries);
        this.deviceCreatorFilterColumn = new DeviceCreatorFilterColumn(5, numFilterColumnEntries);
        this.deviceTypeFilterColumn = new DeviceTypeFilterColumn(6, numFilterColumnEntries);
        this.columnDataContentTypes = new IBrowserColumn[2][];
        this.columnDataContentTypes[BrowserContentType.DEVICE.ordinal()] = new IBrowserColumn[]{this.deviceCollectionFilterColumn, this.deviceLocationFilterColumn, this.deviceFileTypeFilterColumn, this.deviceCategoryFilterColumn, this.deviceTagsFilterColumn, this.deviceCreatorFilterColumn, this.deviceTypeFilterColumn};
        this.columnDataContentTypes[BrowserContentType.PRESET.ordinal()] = new IBrowserColumn[]{new EmptyFilterColumn(0, numFilterColumnEntries), new EmptyFilterColumn(1, numFilterColumnEntries), new EmptyFilterColumn(2, numFilterColumnEntries), new EmptyFilterColumn(3, numFilterColumnEntries), new EmptyFilterColumn(4, numFilterColumnEntries), new EmptyFilterColumn(5, numFilterColumnEntries), new EmptyFilterColumn(6, numFilterColumnEntries), new EmptyFilterColumn(7, numFilterColumnEntries)};
        this.columnData = this.columnDataContentTypes[BrowserContentType.PRESET.ordinal()];
        this.resultData = this.createResultData(this.numResults);
        for (IBrowserColumn column : this.columnDataContentTypes[BrowserContentType.DEVICE.ordinal()]) {
            ((BaseColumn)column).addSelectionListener(() -> this.updateFilteredDevices(true));
        }
        this.browserWindow = ((HostImpl)dataSetup.getHost()).getWindowManager().getMainFrame().getBrowserDialog();
        this.enableObservers(false);
    }

    @Override
    public void enableObservers(boolean enable) {
        this.sender.enableUpdates(Processor.BROWSER, enable);
    }

    @Override
    public boolean isPresetContentType() {
        return this.contentType == BrowserContentType.PRESET;
    }

    @Override
    public int getSelectedContentTypeIndex() {
        return this.contentType.ordinal();
    }

    @Override
    public boolean hasPreviousContentType() {
        return false;
    }

    @Override
    public boolean hasNextContentType() {
        return false;
    }

    @Override
    public void previousContentType() {
    }

    @Override
    public void nextContentType() {
    }

    @Override
    public String getSelectedContentType() {
        return CONTENT_TYPE_NAMES[this.contentType.ordinal()];
    }

    public BrowserContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String[] getContentTypeNames() {
        return new String[]{this.getSelectedContentType()};
    }

    private void setContentType(BrowserContentType contentType) {
        BrowserContentType[] values = BrowserContentType.values();
        int id = contentType.ordinal();
        this.contentType = values[Math.min(Math.max(0, id), values.length - 1)];
        this.columnData = this.columnDataContentTypes[id];
        this.selectedIndex = 0;
        if (contentType == BrowserContentType.DEVICE) {
            this.updateFilteredDevices(false);
        }
        SwingUtilities.invokeLater(() -> {
            this.browserWindow.updateFilters();
            this.browserWindow.updateResults(this.selectedIndex);
            this.browserWindow.setVisible(true);
            this.browserWindow.toFront();
        });
    }

    @Override
    public boolean isPreviewEnabled() {
        return false;
    }

    @Override
    public void togglePreviewEnabled() {
    }

    @Override
    public void setPreviewEnabled(boolean isEnabled) {
    }

    @Override
    public void replace(IItem item) {
        if (item instanceof CursorDeviceImpl) {
            CursorDeviceImpl cdi = (CursorDeviceImpl)item;
            String name = item.getName();
            this.infoText = "Replace: " + (name.length() == 0 ? "Empty" : name);
            this.browse(BrowserContentType.PRESET, cdi.getPosition());
        }
    }

    @Override
    public void addDevice(IChannel channel) {
        this.infoText = "Add device to: " + channel.getName();
        this.browse(BrowserContentType.DEVICE, 0);
    }

    @Override
    public void insertBeforeCursorDevice() {
        this.infoText = "Insert device before: " + this.cursorDevice.getName();
        this.browse(BrowserContentType.DEVICE, this.cursorDevice.getPosition());
    }

    @Override
    public void insertAfterCursorDevice() {
        this.infoText = "Insert device after: " + this.cursorDevice.getName();
        this.browse(BrowserContentType.DEVICE, this.cursorDevice.getPosition() + 1);
    }

    @Override
    public void toggleInsertionPoint() {
        if (this.infoText.startsWith("Insert device before: ")) {
            this.insertAfterCursorDevice();
        } else {
            this.insertBeforeCursorDevice();
        }
    }

    private void browse(BrowserContentType contentType, int insertPos) {
        this.stopBrowsing(false);
        SwingUtilities.invokeLater(() -> this.browserWindow.open(this));
        this.enableObservers(true);
        this.insertPosition = insertPos;
        this.setContentType(contentType);
        this.isBrowserActive = true;
        this.fireActiveObserver(this.isBrowserActive);
    }

    @Override
    public void stopBrowsing(boolean commitSelection) {
        this.browserWindow.close(false, false);
        if (!this.isBrowserActive) {
            return;
        }
        if (commitSelection && this.insertPosition >= 0) {
            switch (this.contentType) {
                case DEVICE: {
                    DeviceMetadataImpl device;
                    ResultItem result = this.getSelectedResultDevice();
                    if (result == null || (device = result.getDevice()) == null) break;
                    this.sender.processStringArg(Processor.DEVICE, "add/" + this.insertPosition + "/", device.getCreationName());
                    break;
                }
                case PRESET: {
                    int index = this.getSelectedResultIndex();
                    if (index == -1) break;
                    this.sender.processIntArg(Processor.DEVICE, "preset", index);
                    break;
                }
            }
        }
        this.enableObservers(false);
        this.insertPosition = -1;
        this.isBrowserActive = false;
        this.fireActiveObserver(this.isBrowserActive);
    }

    @Override
    public boolean isActive() {
        return this.isBrowserActive;
    }

    @Override
    public void selectPreviousResult() {
        this.setSelectedResult(this.selectedIndex - 1);
    }

    @Override
    public void selectNextResult() {
        this.setSelectedResult(this.selectedIndex + 1);
    }

    @Override
    public String getSelectedResult() {
        ResultItem result = this.getSelectedResultDevice();
        return result == null ? null : result.getName();
    }

    private ResultItem getSelectedResultDevice() {
        for (IBrowserColumnItem element : this.resultData) {
            if (!element.isSelected()) continue;
            return (ResultItem)element;
        }
        return null;
    }

    public void setSelectedResult(int index) {
        int length = this.isPresetContentType() ? this.presetModel.getSize() : this.filteredDevices.size();
        this.selectedIndex = Math.min(Math.max(0, index), length - 1);
        SwingUtilities.invokeLater(() -> this.browserWindow.updateResultSelection(this.selectedIndex));
    }

    public void previousResultPage() {
        this.setSelectedResult(this.selectedIndex - this.numResults);
    }

    public void nextResultPage() {
        this.setSelectedResult(this.selectedIndex + this.numResults);
    }

    private IBrowserColumnItem[] createResultData(int count) {
        IBrowserColumnItem[] items = new IBrowserColumnItem[count];
        for (int i = 0; i < count; ++i) {
            items[i] = new ResultItem(i);
        }
        return items;
    }

    public void setPresetSelected(int index) {
        this.selectedIndex = index;
    }

    int translateBankIndexToPageOfSelectedIndex(int index) {
        return this.selectedIndex / this.numResults * this.numResults + index;
    }

    private void updateFilteredDevices(boolean alsoUpdateResults) {
        if (this.isPresetContentType()) {
            return;
        }
        DeviceManager deviceManager = DeviceManager.get();
        DeviceCollection folder = this.deviceCollectionFilterColumn.getCursorIndex() == 0 ? null : deviceManager.getCollection(this.deviceCollectionFilterColumn.getCursorName());
        String category = this.deviceCategoryFilterColumn.getCursorIndex() == 0 ? null : this.deviceCategoryFilterColumn.getCursorName();
        DeviceFileType fileType = this.deviceFileTypeFilterColumn.getCursorIndex() == 0 ? null : DeviceFileType.valueOf(this.deviceFileTypeFilterColumn.getCursorName().toUpperCase(Locale.US));
        String vendor = this.deviceCreatorFilterColumn.getCursorIndex() == 0 ? null : this.deviceCreatorFilterColumn.getCursorName();
        DeviceType type = this.deviceTypeFilterColumn.getCursorIndex() == 0 ? null : DeviceType.valueOf(this.deviceTypeFilterColumn.getCursorName().toUpperCase(Locale.US).replace(' ', '_'));
        this.filteredDevices = deviceManager.filterBy(fileType, category, vendor, folder, type);
        if (this.selectedIndex >= this.filteredDevices.size()) {
            this.selectedIndex = 0;
        }
        if (alsoUpdateResults) {
            SwingUtilities.invokeLater(() -> this.browserWindow.updateResults(this.selectedIndex));
        }
    }

    public List<DeviceMetadataImpl> getFilteredDevices() {
        return this.filteredDevices;
    }

    public DefaultListModel<String> getPresets() {
        return this.presetModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPresetsFile(String filename) {
        if (filename == null) {
            return;
        }
        Object object = this.parsePresetFileLock;
        synchronized (object) {
            PresetFileCacheItem presetFileCacheItem;
            try {
                File file = new File(filename);
                if (!file.exists()) {
                    return;
                }
                presetFileCacheItem = presetFileCache.get(filename);
                if (presetFileCacheItem == null || presetFileCacheItem.time != file.lastModified()) {
                    if (presetFileCacheItem == null) {
                        presetFileCacheItem = new PresetFileCacheItem();
                        presetFileCache.put(filename, presetFileCacheItem);
                    }
                    presetFileCacheItem.iniFile.load(file.getAbsolutePath());
                    int presetCount = Integer.parseInt(presetFileCacheItem.iniFile.get("General", "NbPresets"));
                    presetFileCacheItem.presets = new String[presetCount];
                    for (int i = 0; i < presetCount; ++i) {
                        presetFileCacheItem.presets[i] = presetFileCacheItem.iniFile.get("Preset" + i, "Name");
                    }
                    presetFileCacheItem.time = file.lastModified();
                }
            }
            catch (IOException | NumberFormatException ex) {
                throw new FrameworkException("Could not load file: " + filename, ex);
            }
            this.presetModel.clear();
            this.presetModel.addAll(Arrays.asList(presetFileCacheItem.presets));
            this.presetModel.update();
            this.selectedIndex = 0;
        }
    }

    private static class PresetModel
    extends DefaultListModel<String> {
        private static final long serialVersionUID = 1893811425744940327L;

        private PresetModel() {
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    private class ResultItem
    extends ItemImpl
    implements IBrowserColumnItem {
        public ResultItem(int index) {
            super(null, index);
        }

        @Override
        public boolean doesExist() {
            int resultIndex = this.getIndex();
            if (BrowserImpl.this.isPresetContentType()) {
                return resultIndex < BrowserImpl.this.presetModel.getSize();
            }
            return resultIndex < BrowserImpl.this.filteredDevices.size();
        }

        @Override
        public String getName() {
            int index = this.getIndex();
            if (BrowserImpl.this.isPresetContentType()) {
                return index < BrowserImpl.this.presetModel.getSize() ? (String)BrowserImpl.this.presetModel.get(index) : "";
            }
            int id = BrowserImpl.this.translateBankIndexToPageOfSelectedIndex(index);
            return id < BrowserImpl.this.filteredDevices.size() ? BrowserImpl.this.filteredDevices.get(id).getDisplayName() : "";
        }

        @Override
        public String getName(int limit) {
            return StringUtils.optimizeName(this.getName(), limit);
        }

        @Override
        public boolean isSelected() {
            return BrowserImpl.this.translateBankIndexToPageOfSelectedIndex(this.getIndex()) == BrowserImpl.this.selectedIndex;
        }

        @Override
        public int getHitCount() {
            return 0;
        }

        public DeviceMetadataImpl getDevice() {
            int id = BrowserImpl.this.translateBankIndexToPageOfSelectedIndex(this.getIndex());
            return id < BrowserImpl.this.filteredDevices.size() ? BrowserImpl.this.filteredDevices.get(id) : null;
        }

        @Override
        protected Processor getProcessor() {
            return null;
        }
    }

    private static class PresetFileCacheItem {
        IniEditor iniFile = new IniEditor(true);
        long time;
        String[] presets;

        private PresetFileCacheItem() {
        }
    }
}

