/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.valuechanger;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;

public class TwosComplementValueChanger
implements IValueChanger {
    private int upperBound;
    protected int stepSize;
    private double sensitivity = 1.0;

    public TwosComplementValueChanger(int upperBound, int stepSize) {
        this.upperBound = upperBound;
        this.stepSize = stepSize;
    }

    @Override
    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
    }

    @Override
    public int getStepSize() {
        return this.stepSize;
    }

    @Override
    public void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    @Override
    public int getUpperBound() {
        return this.upperBound;
    }

    @Override
    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    @Override
    public double calcKnobChange(int control) {
        return this.calcKnobChange(control, this.sensitivity);
    }

    @Override
    public double calcKnobChange(int control, double sensitivity) {
        return (double)(this.decode(control) * this.stepSize) * TwosComplementValueChanger.rescale(sensitivity);
    }

    @Override
    public int calcSteppedKnobChange(int control) {
        double result = this.calcKnobChange(control, -100.0);
        if (result >= 0.0) {
            return (int)Math.max(1L, Math.round(result));
        }
        return (int)Math.min(-1L, Math.round(result));
    }

    @Override
    public int decode(int control) {
        return control < 64 ? control : control - 128;
    }

    @Override
    public int encode(int speed) {
        return speed < 0 ? speed + 128 : speed;
    }

    @Override
    public int changeValue(int control, int value) {
        return this.changeValue(control, value, this.sensitivity, this.upperBound);
    }

    @Override
    public int changeValue(int control, int value, double sensitivity, int upperBound) {
        return this.changeValue(control, value, sensitivity, upperBound, 0);
    }

    private int changeValue(int control, int value, double sensitivity, int maxParameterValue, int minParameterValue) {
        double speed = this.calcKnobChange(control, sensitivity);
        return (int)Math.max(Math.min((double)value + speed, (double)maxParameterValue - 1.0), (double)minParameterValue);
    }

    @Override
    public boolean isIncrease(int control) {
        return this.calcKnobChange(control) > 0.0;
    }

    @Override
    public int toMidiValue(int value) {
        return Math.min(value * 127 / (this.getUpperBound() - 1), 127);
    }

    @Override
    public int toDAWValue(int value) {
        return value * (this.getUpperBound() - 1) / 127;
    }

    @Override
    public int toDisplayValue(int value) {
        return value;
    }

    @Override
    public double toNormalizedValue(double value) {
        return Math.min(value / (double)(this.getUpperBound() - 1), 1.0);
    }

    @Override
    public int fromNormalizedValue(double value) {
        return (int)Math.round(value * (double)(this.getUpperBound() - 1));
    }

    public static double rescale(double sensitivity) {
        if (sensitivity < 0.0) {
            return Math.max(0.1, (100.0 + sensitivity) / 100.0);
        }
        return 1.0 + sensitivity / 100.0 * 9.0;
    }
}

