/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.clip;

import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;

public class TemporaryNewCommand<S extends IControlSurface<C>, C extends Configuration>
extends NewCommand<S, C> {
    private final int clipLength;

    public TemporaryNewCommand(int clipLength, IModel model, S surface) {
        super(model, surface);
        this.clipLength = clipLength;
    }

    @Override
    protected int getClipLength() {
        double quartersPerMeasure = this.model.getTransport().getQuartersPerMeasure();
        return (int)(this.clipLength < 2 ? Math.pow(2.0, this.clipLength) : Math.pow(2.0, (double)this.clipLength - 2.0) * quartersPerMeasure);
    }
}

